package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{
  MessageString,
  StorageOptimizerConfigValue,
  StorageOptimizerConfigKey
}
import scala.jdk.CollectionConverters._
final case class StorageOptimizer(
    storageOptimizerType: Optional[zio.aws.lakeformation.model.OptimizerType] =
      Optional.Absent,
    config: Optional[
      Map[StorageOptimizerConfigKey, StorageOptimizerConfigValue]
    ] = Optional.Absent,
    errorMessage: Optional[MessageString] = Optional.Absent,
    warnings: Optional[MessageString] = Optional.Absent,
    lastRunDetails: Optional[MessageString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.StorageOptimizer = {
    import StorageOptimizer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.StorageOptimizer
      .builder()
      .optionallyWith(storageOptimizerType.map(value => value.unwrap))(
        _.storageOptimizerType
      )
      .optionallyWith(
        config.map(value =>
          value
            .map({ case (key, value) =>
              (StorageOptimizerConfigKey.unwrap(
                key
              ): java.lang.String) -> (StorageOptimizerConfigValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.config)
      .optionallyWith(
        errorMessage.map(value => MessageString.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        warnings.map(value => MessageString.unwrap(value): java.lang.String)
      )(_.warnings)
      .optionallyWith(
        lastRunDetails.map(value =>
          MessageString.unwrap(value): java.lang.String
        )
      )(_.lastRunDetails)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.StorageOptimizer.ReadOnly =
    zio.aws.lakeformation.model.StorageOptimizer.wrap(buildAwsValue())
}
object StorageOptimizer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.StorageOptimizer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.StorageOptimizer =
      zio.aws.lakeformation.model.StorageOptimizer(
        storageOptimizerType.map(value => value),
        config.map(value => value),
        errorMessage.map(value => value),
        warnings.map(value => value),
        lastRunDetails.map(value => value)
      )
    def storageOptimizerType
        : Optional[zio.aws.lakeformation.model.OptimizerType]
    def config
        : Optional[Map[StorageOptimizerConfigKey, StorageOptimizerConfigValue]]
    def errorMessage: Optional[MessageString]
    def warnings: Optional[MessageString]
    def lastRunDetails: Optional[MessageString]
    def getStorageOptimizerType
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.OptimizerType] =
      AwsError.unwrapOptionField("storageOptimizerType", storageOptimizerType)
    def getConfig: ZIO[Any, AwsError, Map[
      StorageOptimizerConfigKey,
      StorageOptimizerConfigValue
    ]] = AwsError.unwrapOptionField("config", config)
    def getErrorMessage: ZIO[Any, AwsError, MessageString] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getWarnings: ZIO[Any, AwsError, MessageString] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getLastRunDetails: ZIO[Any, AwsError, MessageString] =
      AwsError.unwrapOptionField("lastRunDetails", lastRunDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.StorageOptimizer
  ) extends zio.aws.lakeformation.model.StorageOptimizer.ReadOnly {
    override val storageOptimizerType
        : Optional[zio.aws.lakeformation.model.OptimizerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageOptimizerType())
        .map(value => zio.aws.lakeformation.model.OptimizerType.wrap(value))
    override val config: Optional[
      Map[StorageOptimizerConfigKey, StorageOptimizerConfigValue]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.config())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lakeformation.model.primitives.StorageOptimizerConfigKey(
              key
            ) -> zio.aws.lakeformation.model.primitives
              .StorageOptimizerConfigValue(value)
          })
          .toMap
      )
    override val errorMessage: Optional[MessageString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.lakeformation.model.primitives.MessageString(value))
    override val warnings: Optional[MessageString] = zio.aws.core.internal
      .optionalFromNullable(impl.warnings())
      .map(value => zio.aws.lakeformation.model.primitives.MessageString(value))
    override val lastRunDetails: Optional[MessageString] = zio.aws.core.internal
      .optionalFromNullable(impl.lastRunDetails())
      .map(value => zio.aws.lakeformation.model.primitives.MessageString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.StorageOptimizer
  ): zio.aws.lakeformation.model.StorageOptimizer.ReadOnly = new Wrapper(impl)
}
