package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{
  LastModifiedTimestamp,
  IAMRoleArn,
  ResourceArnString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ResourceInfo(
    resourceArn: Optional[ResourceArnString] = Optional.Absent,
    roleArn: Optional[IAMRoleArn] = Optional.Absent,
    lastModified: Optional[LastModifiedTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ResourceInfo = {
    import ResourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ResourceInfo
      .builder()
      .optionallyWith(
        resourceArn.map(value =>
          ResourceArnString.unwrap(value): java.lang.String
        )
      )(_.resourceArn)
      .optionallyWith(
        roleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        lastModified.map(value => LastModifiedTimestamp.unwrap(value): Instant)
      )(_.lastModified)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ResourceInfo.ReadOnly =
    zio.aws.lakeformation.model.ResourceInfo.wrap(buildAwsValue())
}
object ResourceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ResourceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ResourceInfo =
      zio.aws.lakeformation.model.ResourceInfo(
        resourceArn.map(value => value),
        roleArn.map(value => value),
        lastModified.map(value => value)
      )
    def resourceArn: Optional[ResourceArnString]
    def roleArn: Optional[IAMRoleArn]
    def lastModified: Optional[LastModifiedTimestamp]
    def getResourceArn: ZIO[Any, AwsError, ResourceArnString] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getLastModified: ZIO[Any, AwsError, LastModifiedTimestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ResourceInfo
  ) extends zio.aws.lakeformation.model.ResourceInfo.ReadOnly {
    override val resourceArn: Optional[ResourceArnString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceArn())
        .map(value =>
          zio.aws.lakeformation.model.primitives.ResourceArnString(value)
        )
    override val roleArn: Optional[IAMRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lakeformation.model.primitives.IAMRoleArn(value))
    override val lastModified: Optional[LastModifiedTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModified())
        .map(value =>
          zio.aws.lakeformation.model.primitives.LastModifiedTimestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ResourceInfo
  ): zio.aws.lakeformation.model.ResourceInfo.ReadOnly = new Wrapper(impl)
}
