package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{
  TransactionIdString,
  Timestamp,
  QueryPlanningContextDatabaseNameString,
  CatalogIdString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class QueryPlanningContext(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    databaseName: QueryPlanningContextDatabaseNameString,
    queryAsOfTime: Optional[Timestamp] = Optional.Absent,
    queryParameters: Optional[Map[String, String]] = Optional.Absent,
    transactionId: Optional[TransactionIdString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.QueryPlanningContext = {
    import QueryPlanningContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.QueryPlanningContext
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(
        QueryPlanningContextDatabaseNameString.unwrap(
          databaseName
        ): java.lang.String
      )
      .optionallyWith(
        queryAsOfTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.queryAsOfTime)
      .optionallyWith(
        queryParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.queryParameters)
      .optionallyWith(
        transactionId.map(value =>
          TransactionIdString.unwrap(value): java.lang.String
        )
      )(_.transactionId)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.QueryPlanningContext.ReadOnly =
    zio.aws.lakeformation.model.QueryPlanningContext.wrap(buildAwsValue())
}
object QueryPlanningContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.QueryPlanningContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.QueryPlanningContext =
      zio.aws.lakeformation.model.QueryPlanningContext(
        catalogId.map(value => value),
        databaseName,
        queryAsOfTime.map(value => value),
        queryParameters.map(value => value),
        transactionId.map(value => value)
      )
    def catalogId: Optional[CatalogIdString]
    def databaseName: QueryPlanningContextDatabaseNameString
    def queryAsOfTime: Optional[Timestamp]
    def queryParameters: Optional[Map[String, String]]
    def transactionId: Optional[TransactionIdString]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName
        : ZIO[Any, Nothing, QueryPlanningContextDatabaseNameString] =
      ZIO.succeed(databaseName)
    def getQueryAsOfTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("queryAsOfTime", queryAsOfTime)
    def getQueryParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("queryParameters", queryParameters)
    def getTransactionId: ZIO[Any, AwsError, TransactionIdString] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.QueryPlanningContext
  ) extends zio.aws.lakeformation.model.QueryPlanningContext.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: QueryPlanningContextDatabaseNameString =
      zio.aws.lakeformation.model.primitives
        .QueryPlanningContextDatabaseNameString(impl.databaseName())
    override val queryAsOfTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.queryAsOfTime())
      .map(value => zio.aws.lakeformation.model.primitives.Timestamp(value))
    override val queryParameters: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val transactionId: Optional[TransactionIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transactionId())
        .map(value =>
          zio.aws.lakeformation.model.primitives.TransactionIdString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.QueryPlanningContext
  ): zio.aws.lakeformation.model.QueryPlanningContext.ReadOnly = new Wrapper(
    impl
  )
}
