package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{
  TokenString,
  PageSize,
  CatalogIdString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTransactionsRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    statusFilter: Optional[
      zio.aws.lakeformation.model.TransactionStatusFilter
    ] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[TokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest = {
    import ListTransactionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .optionallyWith(statusFilter.map(value => value.unwrap))(_.statusFilter)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => TokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListTransactionsRequest.ReadOnly =
    zio.aws.lakeformation.model.ListTransactionsRequest.wrap(buildAwsValue())
}
object ListTransactionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListTransactionsRequest =
      zio.aws.lakeformation.model.ListTransactionsRequest(
        catalogId.map(value => value),
        statusFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def catalogId: Optional[CatalogIdString]
    def statusFilter
        : Optional[zio.aws.lakeformation.model.TransactionStatusFilter]
    def maxResults: Optional[PageSize]
    def nextToken: Optional[TokenString]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getStatusFilter: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TransactionStatusFilter
    ] = AwsError.unwrapOptionField("statusFilter", statusFilter)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, TokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest
  ) extends zio.aws.lakeformation.model.ListTransactionsRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val statusFilter
        : Optional[zio.aws.lakeformation.model.TransactionStatusFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusFilter())
        .map(value =>
          zio.aws.lakeformation.model.TransactionStatusFilter.wrap(value)
        )
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val nextToken: Optional[TokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.TokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest
  ): zio.aws.lakeformation.model.ListTransactionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
