package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait TransactionStatusFilter {
  def unwrap: software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter
}
object TransactionStatusFilter {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter
  ): zio.aws.lakeformation.model.TransactionStatusFilter = value match {
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.COMMITTED =>
      val r = COMMITTED
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.ABORTED =>
      val r = ABORTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.TransactionStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.lakeformation.model.TransactionStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.ALL
  }
  case object COMPLETED
      extends zio.aws.lakeformation.model.TransactionStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.COMPLETED
  }
  case object ACTIVE
      extends zio.aws.lakeformation.model.TransactionStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.ACTIVE
  }
  case object COMMITTED
      extends zio.aws.lakeformation.model.TransactionStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.COMMITTED
  }
  case object ABORTED
      extends zio.aws.lakeformation.model.TransactionStatusFilter {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatusFilter.ABORTED
  }
}
