package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaggedDatabase(
    database: Optional[zio.aws.lakeformation.model.DatabaseResource] =
      Optional.Absent,
    lfTags: Optional[Iterable[zio.aws.lakeformation.model.LFTagPair]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.TaggedDatabase = {
    import TaggedDatabase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.TaggedDatabase
      .builder()
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .optionallyWith(
        lfTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lfTags)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.TaggedDatabase.ReadOnly =
    zio.aws.lakeformation.model.TaggedDatabase.wrap(buildAwsValue())
}
object TaggedDatabase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.TaggedDatabase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.TaggedDatabase =
      zio.aws.lakeformation.model.TaggedDatabase(
        database.map(value => value.asEditable),
        lfTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def database
        : Optional[zio.aws.lakeformation.model.DatabaseResource.ReadOnly]
    def lfTags: Optional[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]]
    def getDatabase: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DatabaseResource.ReadOnly
    ] = AwsError.unwrapOptionField("database", database)
    def getLfTags: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.LFTagPair.ReadOnly
    ]] = AwsError.unwrapOptionField("lfTags", lfTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.TaggedDatabase
  ) extends zio.aws.lakeformation.model.TaggedDatabase.ReadOnly {
    override val database
        : Optional[zio.aws.lakeformation.model.DatabaseResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.database())
        .map(value => zio.aws.lakeformation.model.DatabaseResource.wrap(value))
    override val lfTags
        : Optional[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lfTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.LFTagPair.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.TaggedDatabase
  ): zio.aws.lakeformation.model.TaggedDatabase.ReadOnly = new Wrapper(impl)
}
