package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{NameString, CatalogIdString}
import scala.jdk.CollectionConverters._
final case class TableResource(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    databaseName: NameString,
    name: Optional[NameString] = Optional.Absent,
    tableWildcard: Optional[zio.aws.lakeformation.model.TableWildcard] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.TableResource = {
    import TableResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.TableResource
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .optionallyWith(
        name.map(value => NameString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(tableWildcard.map(value => value.buildAwsValue()))(
        _.tableWildcard
      )
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.TableResource.ReadOnly =
    zio.aws.lakeformation.model.TableResource.wrap(buildAwsValue())
}
object TableResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.TableResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.TableResource =
      zio.aws.lakeformation.model.TableResource(
        catalogId.map(value => value),
        databaseName,
        name.map(value => value),
        tableWildcard.map(value => value.asEditable)
      )
    def catalogId: Optional[CatalogIdString]
    def databaseName: NameString
    def name: Optional[NameString]
    def tableWildcard
        : Optional[zio.aws.lakeformation.model.TableWildcard.ReadOnly]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("name", name)
    def getTableWildcard: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TableWildcard.ReadOnly
    ] = AwsError.unwrapOptionField("tableWildcard", tableWildcard)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.TableResource
  ) extends zio.aws.lakeformation.model.TableResource.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.databaseName())
    override val name: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
    override val tableWildcard
        : Optional[zio.aws.lakeformation.model.TableWildcard.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableWildcard())
        .map(value => zio.aws.lakeformation.model.TableWildcard.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.TableResource
  ): zio.aws.lakeformation.model.TableResource.ReadOnly = new Wrapper(impl)
}
