package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{ObjectSize, ETagString, URI}
import scala.jdk.CollectionConverters._
final case class TableObject(
    uri: Optional[URI] = Optional.Absent,
    eTag: Optional[ETagString] = Optional.Absent,
    size: Optional[ObjectSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.TableObject = {
    import TableObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.TableObject
      .builder()
      .optionallyWith(uri.map(value => URI.unwrap(value): java.lang.String))(
        _.uri
      )
      .optionallyWith(
        eTag.map(value => ETagString.unwrap(value): java.lang.String)
      )(_.eTag)
      .optionallyWith(
        size.map(value => ObjectSize.unwrap(value): java.lang.Long)
      )(_.size)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.TableObject.ReadOnly =
    zio.aws.lakeformation.model.TableObject.wrap(buildAwsValue())
}
object TableObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.TableObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.TableObject =
      zio.aws.lakeformation.model.TableObject(
        uri.map(value => value),
        eTag.map(value => value),
        size.map(value => value)
      )
    def uri: Optional[URI]
    def eTag: Optional[ETagString]
    def size: Optional[ObjectSize]
    def getUri: ZIO[Any, AwsError, URI] = AwsError.unwrapOptionField("uri", uri)
    def getETag: ZIO[Any, AwsError, ETagString] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getSize: ZIO[Any, AwsError, ObjectSize] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.TableObject
  ) extends zio.aws.lakeformation.model.TableObject.ReadOnly {
    override val uri: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.lakeformation.model.primitives.URI(value))
    override val eTag: Optional[ETagString] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.lakeformation.model.primitives.ETagString(value))
    override val size: Optional[ObjectSize] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => zio.aws.lakeformation.model.primitives.ObjectSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.TableObject
  ): zio.aws.lakeformation.model.TableObject.ReadOnly = new Wrapper(impl)
}
