package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CommitTransactionResponse(
    transactionStatus: Optional[zio.aws.lakeformation.model.TransactionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse = {
    import CommitTransactionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse
      .builder()
      .optionallyWith(transactionStatus.map(value => value.unwrap))(
        _.transactionStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.CommitTransactionResponse.ReadOnly =
    zio.aws.lakeformation.model.CommitTransactionResponse.wrap(buildAwsValue())
}
object CommitTransactionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.CommitTransactionResponse =
      zio.aws.lakeformation.model
        .CommitTransactionResponse(transactionStatus.map(value => value))
    def transactionStatus
        : Optional[zio.aws.lakeformation.model.TransactionStatus]
    def getTransactionStatus
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.TransactionStatus] =
      AwsError.unwrapOptionField("transactionStatus", transactionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse
  ) extends zio.aws.lakeformation.model.CommitTransactionResponse.ReadOnly {
    override val transactionStatus
        : Optional[zio.aws.lakeformation.model.TransactionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transactionStatus())
        .map(value => zio.aws.lakeformation.model.TransactionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse
  ): zio.aws.lakeformation.model.CommitTransactionResponse.ReadOnly =
    new Wrapper(impl)
}
