package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.{
  WorkUnitTokenString,
  WorkUnitIdLong
}
import scala.jdk.CollectionConverters._
final case class WorkUnitRange(
    workUnitIdMax: WorkUnitIdLong,
    workUnitIdMin: WorkUnitIdLong,
    workUnitToken: WorkUnitTokenString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.WorkUnitRange = {
    import WorkUnitRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.WorkUnitRange
      .builder()
      .workUnitIdMax(WorkUnitIdLong.unwrap(workUnitIdMax): java.lang.Long)
      .workUnitIdMin(WorkUnitIdLong.unwrap(workUnitIdMin): java.lang.Long)
      .workUnitToken(
        WorkUnitTokenString.unwrap(workUnitToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.WorkUnitRange.ReadOnly =
    zio.aws.lakeformation.model.WorkUnitRange.wrap(buildAwsValue())
}
object WorkUnitRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.WorkUnitRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.WorkUnitRange =
      zio.aws.lakeformation.model
        .WorkUnitRange(workUnitIdMax, workUnitIdMin, workUnitToken)
    def workUnitIdMax: WorkUnitIdLong
    def workUnitIdMin: WorkUnitIdLong
    def workUnitToken: WorkUnitTokenString
    def getWorkUnitIdMax: ZIO[Any, Nothing, WorkUnitIdLong] =
      ZIO.succeed(workUnitIdMax)
    def getWorkUnitIdMin: ZIO[Any, Nothing, WorkUnitIdLong] =
      ZIO.succeed(workUnitIdMin)
    def getWorkUnitToken: ZIO[Any, Nothing, WorkUnitTokenString] =
      ZIO.succeed(workUnitToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.WorkUnitRange
  ) extends zio.aws.lakeformation.model.WorkUnitRange.ReadOnly {
    override val workUnitIdMax: WorkUnitIdLong =
      zio.aws.lakeformation.model.primitives
        .WorkUnitIdLong(impl.workUnitIdMax())
    override val workUnitIdMin: WorkUnitIdLong =
      zio.aws.lakeformation.model.primitives
        .WorkUnitIdLong(impl.workUnitIdMin())
    override val workUnitToken: WorkUnitTokenString =
      zio.aws.lakeformation.model.primitives
        .WorkUnitTokenString(impl.workUnitToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.WorkUnitRange
  ): zio.aws.lakeformation.model.WorkUnitRange.ReadOnly = new Wrapper(impl)
}
