package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchRevokePermissionsResponse(
    failures: Optional[
      Iterable[zio.aws.lakeformation.model.BatchPermissionsFailureEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse = {
    import BatchRevokePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.BatchRevokePermissionsResponse.ReadOnly =
    zio.aws.lakeformation.model.BatchRevokePermissionsResponse
      .wrap(buildAwsValue())
}
object BatchRevokePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.BatchRevokePermissionsResponse =
      zio.aws.lakeformation.model.BatchRevokePermissionsResponse(
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failures: Optional[
      List[zio.aws.lakeformation.model.BatchPermissionsFailureEntry.ReadOnly]
    ]
    def getFailures: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.BatchPermissionsFailureEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse
  ) extends zio.aws.lakeformation.model.BatchRevokePermissionsResponse.ReadOnly {
    override val failures: Optional[
      List[zio.aws.lakeformation.model.BatchPermissionsFailureEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.BatchPermissionsFailureEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse
  ): zio.aws.lakeformation.model.BatchRevokePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
