package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WriteOperation(
    addObject: Optional[zio.aws.lakeformation.model.AddObjectInput] =
      Optional.Absent,
    deleteObject: Optional[zio.aws.lakeformation.model.DeleteObjectInput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.WriteOperation = {
    import WriteOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.WriteOperation
      .builder()
      .optionallyWith(addObject.map(value => value.buildAwsValue()))(
        _.addObject
      )
      .optionallyWith(deleteObject.map(value => value.buildAwsValue()))(
        _.deleteObject
      )
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.WriteOperation.ReadOnly =
    zio.aws.lakeformation.model.WriteOperation.wrap(buildAwsValue())
}
object WriteOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.WriteOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.WriteOperation =
      zio.aws.lakeformation.model.WriteOperation(
        addObject.map(value => value.asEditable),
        deleteObject.map(value => value.asEditable)
      )
    def addObject: Optional[zio.aws.lakeformation.model.AddObjectInput.ReadOnly]
    def deleteObject
        : Optional[zio.aws.lakeformation.model.DeleteObjectInput.ReadOnly]
    def getAddObject: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.AddObjectInput.ReadOnly
    ] = AwsError.unwrapOptionField("addObject", addObject)
    def getDeleteObject: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DeleteObjectInput.ReadOnly
    ] = AwsError.unwrapOptionField("deleteObject", deleteObject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.WriteOperation
  ) extends zio.aws.lakeformation.model.WriteOperation.ReadOnly {
    override val addObject
        : Optional[zio.aws.lakeformation.model.AddObjectInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addObject())
        .map(value => zio.aws.lakeformation.model.AddObjectInput.wrap(value))
    override val deleteObject
        : Optional[zio.aws.lakeformation.model.DeleteObjectInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteObject())
        .map(value => zio.aws.lakeformation.model.DeleteObjectInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.WriteOperation
  ): zio.aws.lakeformation.model.WriteOperation.ReadOnly = new Wrapper(impl)
}
