package zio.aws.lakeformation.model
import zio.aws.lakeformation.model.primitives.{
  PageSize,
  Token,
  ResourceArnString,
  CatalogIdString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetEffectivePermissionsForPathRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    resourceArn: ResourceArnString,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest = {
    import GetEffectivePermissionsForPathRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest.ReadOnly =
    zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest
      .wrap(buildAwsValue())
}
object GetEffectivePermissionsForPathRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest =
      zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest(
        catalogId.map(value => value),
        resourceArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def catalogId: Optional[CatalogIdString]
    def resourceArn: ResourceArnString
    def nextToken: Optional[Token]
    def maxResults: Optional[PageSize]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest
  ) extends zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val resourceArn: ResourceArnString =
      zio.aws.lakeformation.model.primitives
        .ResourceArnString(impl.resourceArn())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest
  ): zio.aws.lakeformation.model.GetEffectivePermissionsForPathRequest.ReadOnly =
    new Wrapper(impl)
}
