package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{
  PartitionValueString,
  ObjectSize,
  ETagString,
  URI
}
import scala.jdk.CollectionConverters._
final case class AddObjectInput(
    uri: URI,
    eTag: ETagString,
    size: ObjectSize,
    partitionValues: Optional[Iterable[PartitionValueString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.AddObjectInput = {
    import AddObjectInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.AddObjectInput
      .builder()
      .uri(URI.unwrap(uri): java.lang.String)
      .eTag(ETagString.unwrap(eTag): java.lang.String)
      .size(ObjectSize.unwrap(size): java.lang.Long)
      .optionallyWith(
        partitionValues.map(value =>
          value.map { item =>
            PartitionValueString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionValues)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.AddObjectInput.ReadOnly =
    zio.aws.lakeformation.model.AddObjectInput.wrap(buildAwsValue())
}
object AddObjectInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.AddObjectInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.AddObjectInput =
      zio.aws.lakeformation.model.AddObjectInput(
        uri,
        eTag,
        size,
        partitionValues.map(value => value)
      )
    def uri: URI
    def eTag: ETagString
    def size: ObjectSize
    def partitionValues: Optional[List[PartitionValueString]]
    def getUri: ZIO[Any, Nothing, URI] = ZIO.succeed(uri)
    def getETag: ZIO[Any, Nothing, ETagString] = ZIO.succeed(eTag)
    def getSize: ZIO[Any, Nothing, ObjectSize] = ZIO.succeed(size)
    def getPartitionValues: ZIO[Any, AwsError, List[PartitionValueString]] =
      AwsError.unwrapOptionField("partitionValues", partitionValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.AddObjectInput
  ) extends zio.aws.lakeformation.model.AddObjectInput.ReadOnly {
    override val uri: URI =
      zio.aws.lakeformation.model.primitives.URI(impl.uri())
    override val eTag: ETagString =
      zio.aws.lakeformation.model.primitives.ETagString(impl.eTag())
    override val size: ObjectSize =
      zio.aws.lakeformation.model.primitives.ObjectSize(impl.size())
    override val partitionValues: Optional[List[PartitionValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.primitives.PartitionValueString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.AddObjectInput
  ): zio.aws.lakeformation.model.AddObjectInput.ReadOnly = new Wrapper(impl)
}
