package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lakeformation.model.primitives.{
  LFTagValue,
  LFTagKey,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class UpdateLfTagRequest(
    catalogId: Optional[CatalogIdString] = Optional.Absent,
    tagKey: LFTagKey,
    tagValuesToDelete: Optional[Iterable[LFTagValue]] = Optional.Absent,
    tagValuesToAdd: Optional[Iterable[LFTagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest = {
    import UpdateLfTagRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .tagKey(LFTagKey.unwrap(tagKey): java.lang.String)
      .optionallyWith(
        tagValuesToDelete.map(value =>
          value.map { item =>
            LFTagValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagValuesToDelete)
      .optionallyWith(
        tagValuesToAdd.map(value =>
          value.map { item =>
            LFTagValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagValuesToAdd)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.UpdateLfTagRequest.ReadOnly =
    zio.aws.lakeformation.model.UpdateLfTagRequest.wrap(buildAwsValue())
}
object UpdateLfTagRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.UpdateLfTagRequest =
      zio.aws.lakeformation.model.UpdateLfTagRequest(
        catalogId.map(value => value),
        tagKey,
        tagValuesToDelete.map(value => value),
        tagValuesToAdd.map(value => value)
      )
    def catalogId: Optional[CatalogIdString]
    def tagKey: LFTagKey
    def tagValuesToDelete: Optional[List[LFTagValue]]
    def tagValuesToAdd: Optional[List[LFTagValue]]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getTagKey: ZIO[Any, Nothing, LFTagKey] = ZIO.succeed(tagKey)
    def getTagValuesToDelete: ZIO[Any, AwsError, List[LFTagValue]] =
      AwsError.unwrapOptionField("tagValuesToDelete", tagValuesToDelete)
    def getTagValuesToAdd: ZIO[Any, AwsError, List[LFTagValue]] =
      AwsError.unwrapOptionField("tagValuesToAdd", tagValuesToAdd)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest
  ) extends zio.aws.lakeformation.model.UpdateLfTagRequest.ReadOnly {
    override val catalogId: Optional[CatalogIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val tagKey: LFTagKey =
      zio.aws.lakeformation.model.primitives.LFTagKey(impl.tagKey())
    override val tagValuesToDelete: Optional[List[LFTagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagValuesToDelete())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.primitives.LFTagValue(item)
          }.toList
        )
    override val tagValuesToAdd: Optional[List[LFTagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagValuesToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.primitives.LFTagValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest
  ): zio.aws.lakeformation.model.UpdateLfTagRequest.ReadOnly = new Wrapper(impl)
}
