package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RemoveLfTagsFromResourceResponse(
    failures: Optional[Iterable[zio.aws.lakeformation.model.LFTagError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse = {
    import RemoveLfTagsFromResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse.ReadOnly =
    zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse
      .wrap(buildAwsValue())
}
object RemoveLfTagsFromResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse =
      zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse(
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failures
        : Optional[List[zio.aws.lakeformation.model.LFTagError.ReadOnly]]
    def getFailures: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.LFTagError.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse
  ) extends zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse.ReadOnly {
    override val failures
        : Optional[List[zio.aws.lakeformation.model.LFTagError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.LFTagError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse
  ): zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse.ReadOnly =
    new Wrapper(impl)
}
