package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  IAMRoleArn,
  NullableBoolean,
  ResourceArnString
}
import scala.jdk.CollectionConverters._
final case class RegisterResourceRequest(
    resourceArn: ResourceArnString,
    useServiceLinkedRole: Option[NullableBoolean] = None,
    roleArn: Option[IAMRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest = {
    import RegisterResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        useServiceLinkedRole.map(value => value: java.lang.Boolean)
      )(_.useServiceLinkedRole)
      .optionallyWith(
        roleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.RegisterResourceRequest.ReadOnly =
    zio.aws.lakeformation.model.RegisterResourceRequest.wrap(buildAwsValue())
}
object RegisterResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.RegisterResourceRequest =
      zio.aws.lakeformation.model.RegisterResourceRequest(
        resourceArn,
        useServiceLinkedRole.map(value => value),
        roleArn.map(value => value)
      )
    def resourceArn: ResourceArnString
    def useServiceLinkedRole: Option[NullableBoolean]
    def roleArn: Option[IAMRoleArn]
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
    def getUseServiceLinkedRole: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("useServiceLinkedRole", useServiceLinkedRole)
    def getRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest
  ) extends zio.aws.lakeformation.model.RegisterResourceRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.lakeformation.model.primitives
        .ResourceArnString(impl.resourceArn())
    override val useServiceLinkedRole: Option[NullableBoolean] = scala
      .Option(impl.useServiceLinkedRole())
      .map(value => value: NullableBoolean)
    override val roleArn: Option[IAMRoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.lakeformation.model.primitives.IAMRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest
  ): zio.aws.lakeformation.model.RegisterResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
