package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PrincipalPermissions(
    principal: Option[zio.aws.lakeformation.model.DataLakePrincipal] = None,
    permissions: Option[Iterable[zio.aws.lakeformation.model.Permission]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions = {
    import PrincipalPermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions
      .builder()
      .optionallyWith(principal.map(value => value.buildAwsValue()))(
        _.principal
      )
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly =
    zio.aws.lakeformation.model.PrincipalPermissions.wrap(buildAwsValue())
}
object PrincipalPermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.PrincipalPermissions =
      zio.aws.lakeformation.model.PrincipalPermissions(
        principal.map(value => value.asEditable),
        permissions.map(value => value)
      )
    def principal
        : Option[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]
    def permissions: Option[List[zio.aws.lakeformation.model.Permission]]
    def getPrincipal: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ] = AwsError.unwrapOptionField("principal", principal)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField("permissions", permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions
  ) extends zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly {
    override val principal
        : Option[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly] = scala
      .Option(impl.principal())
      .map(value => zio.aws.lakeformation.model.DataLakePrincipal.wrap(value))
    override val permissions
        : Option[List[zio.aws.lakeformation.model.Permission]] = scala
      .Option(impl.permissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.Permission.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions
  ): zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly = new Wrapper(
    impl
  )
}
