package zio.aws.lakeformation.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{PageSize, Token}
import scala.jdk.CollectionConverters._
final case class ListDataCellsFilterRequest(
    table: Option[zio.aws.lakeformation.model.TableResource] = None,
    nextToken: Option[Token] = None,
    maxResults: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest = {
    import ListDataCellsFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest
      .builder()
      .optionallyWith(table.map(value => value.buildAwsValue()))(_.table)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.ListDataCellsFilterRequest.ReadOnly =
    zio.aws.lakeformation.model.ListDataCellsFilterRequest.wrap(buildAwsValue())
}
object ListDataCellsFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListDataCellsFilterRequest =
      zio.aws.lakeformation.model.ListDataCellsFilterRequest(
        table.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def table: Option[zio.aws.lakeformation.model.TableResource.ReadOnly]
    def nextToken: Option[Token]
    def maxResults: Option[PageSize]
    def getTable: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TableResource.ReadOnly
    ] = AwsError.unwrapOptionField("table", table)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest
  ) extends zio.aws.lakeformation.model.ListDataCellsFilterRequest.ReadOnly {
    override val table
        : Option[zio.aws.lakeformation.model.TableResource.ReadOnly] = scala
      .Option(impl.table())
      .map(value => zio.aws.lakeformation.model.TableResource.wrap(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest
  ): zio.aws.lakeformation.model.ListDataCellsFilterRequest.ReadOnly =
    new Wrapper(impl)
}
