package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.{LFTagValue, LFTagKey}
import scala.jdk.CollectionConverters._
final case class LFTag(tagKey: LFTagKey, tagValues: Iterable[LFTagValue]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.LFTag = {
    import LFTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.LFTag
      .builder()
      .tagKey(LFTagKey.unwrap(tagKey): java.lang.String)
      .tagValues(tagValues.map { item =>
        LFTagValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.LFTag.ReadOnly =
    zio.aws.lakeformation.model.LFTag.wrap(buildAwsValue())
}
object LFTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.LFTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.LFTag =
      zio.aws.lakeformation.model.LFTag(tagKey, tagValues)
    def tagKey: LFTagKey
    def tagValues: List[LFTagValue]
    def getTagKey: ZIO[Any, Nothing, LFTagKey] = ZIO.succeed(tagKey)
    def getTagValues: ZIO[Any, Nothing, List[LFTagValue]] =
      ZIO.succeed(tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.LFTag
  ) extends zio.aws.lakeformation.model.LFTag.ReadOnly {
    override val tagKey: LFTagKey =
      zio.aws.lakeformation.model.primitives.LFTagKey(impl.tagKey())
    override val tagValues: List[LFTagValue] = impl
      .tagValues()
      .asScala
      .map { item =>
        zio.aws.lakeformation.model.primitives.LFTagValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.LFTag
  ): zio.aws.lakeformation.model.LFTag.ReadOnly = new Wrapper(impl)
}
