package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.CatalogIdString
import scala.jdk.CollectionConverters._
final case class GrantPermissionsRequest(
    catalogId: Option[CatalogIdString] = None,
    principal: zio.aws.lakeformation.model.DataLakePrincipal,
    resource: zio.aws.lakeformation.model.Resource,
    permissions: Iterable[zio.aws.lakeformation.model.Permission],
    permissionsWithGrantOption: Option[
      Iterable[zio.aws.lakeformation.model.Permission]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest = {
    import GrantPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .principal(principal.buildAwsValue())
      .resource(resource.buildAwsValue())
      .permissionsWithStrings(permissions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        permissionsWithGrantOption.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithGrantOptionWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.GrantPermissionsRequest.ReadOnly =
    zio.aws.lakeformation.model.GrantPermissionsRequest.wrap(buildAwsValue())
}
object GrantPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GrantPermissionsRequest =
      zio.aws.lakeformation.model.GrantPermissionsRequest(
        catalogId.map(value => value),
        principal.asEditable,
        resource.asEditable,
        permissions,
        permissionsWithGrantOption.map(value => value)
      )
    def catalogId: Option[CatalogIdString]
    def principal: zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    def resource: zio.aws.lakeformation.model.Resource.ReadOnly
    def permissions: List[zio.aws.lakeformation.model.Permission]
    def permissionsWithGrantOption
        : Option[List[zio.aws.lakeformation.model.Permission]]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getPrincipal: ZIO[
      Any,
      Nothing,
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ] = ZIO.succeed(principal)
    def getResource
        : ZIO[Any, Nothing, zio.aws.lakeformation.model.Resource.ReadOnly] =
      ZIO.succeed(resource)
    def getPermissions
        : ZIO[Any, Nothing, List[zio.aws.lakeformation.model.Permission]] =
      ZIO.succeed(permissions)
    def getPermissionsWithGrantOption
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField(
        "permissionsWithGrantOption",
        permissionsWithGrantOption
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest
  ) extends zio.aws.lakeformation.model.GrantPermissionsRequest.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val principal
        : zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly =
      zio.aws.lakeformation.model.DataLakePrincipal.wrap(impl.principal())
    override val resource: zio.aws.lakeformation.model.Resource.ReadOnly =
      zio.aws.lakeformation.model.Resource.wrap(impl.resource())
    override val permissions: List[zio.aws.lakeformation.model.Permission] =
      impl
        .permissions()
        .asScala
        .map { item =>
          zio.aws.lakeformation.model.Permission.wrap(item)
        }
        .toList
    override val permissionsWithGrantOption
        : Option[List[zio.aws.lakeformation.model.Permission]] = scala
      .Option(impl.permissionsWithGrantOption())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.Permission.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest
  ): zio.aws.lakeformation.model.GrantPermissionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
