package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.ErrorMessageString
import scala.jdk.CollectionConverters._
final case class GetQueryStateResponse(
    error: Option[ErrorMessageString] = None,
    state: zio.aws.lakeformation.model.QueryStateString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse = {
    import GetQueryStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse
      .builder()
      .optionallyWith(
        error.map(value => ErrorMessageString.unwrap(value): java.lang.String)
      )(_.error)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.GetQueryStateResponse.ReadOnly =
    zio.aws.lakeformation.model.GetQueryStateResponse.wrap(buildAwsValue())
}
object GetQueryStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetQueryStateResponse =
      zio.aws.lakeformation.model
        .GetQueryStateResponse(error.map(value => value), state)
    def error: Option[ErrorMessageString]
    def state: zio.aws.lakeformation.model.QueryStateString
    def getError: ZIO[Any, AwsError, ErrorMessageString] =
      AwsError.unwrapOptionField("error", error)
    def getState
        : ZIO[Any, Nothing, zio.aws.lakeformation.model.QueryStateString] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse
  ) extends zio.aws.lakeformation.model.GetQueryStateResponse.ReadOnly {
    override val error: Option[ErrorMessageString] = scala
      .Option(impl.error())
      .map(value =>
        zio.aws.lakeformation.model.primitives.ErrorMessageString(value)
      )
    override val state: zio.aws.lakeformation.model.QueryStateString =
      zio.aws.lakeformation.model.QueryStateString.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse
  ): zio.aws.lakeformation.model.GetQueryStateResponse.ReadOnly = new Wrapper(
    impl
  )
}
