package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  StorageOptimizerConfigValue,
  StorageOptimizerConfigKey,
  NameString,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class UpdateTableStorageOptimizerRequest(
    catalogId: Option[CatalogIdString] = None,
    databaseName: NameString,
    tableName: NameString,
    storageOptimizerConfig: Map[
      zio.aws.lakeformation.model.OptimizerType,
      Map[StorageOptimizerConfigKey, StorageOptimizerConfigValue]
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest = {
    import UpdateTableStorageOptimizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .tableName(NameString.unwrap(tableName): java.lang.String)
      .storageOptimizerConfigWithStrings(
        storageOptimizerConfig
          .map({ case (key, value) =>
            key.unwrap.toString -> value
              .map({ case (key, value) =>
                (StorageOptimizerConfigKey.unwrap(
                  key
                ): java.lang.String) -> (StorageOptimizerConfigValue
                  .unwrap(value): java.lang.String)
              })
              .asJava
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.UpdateTableStorageOptimizerRequest.ReadOnly =
    zio.aws.lakeformation.model.UpdateTableStorageOptimizerRequest
      .wrap(buildAwsValue())
}
object UpdateTableStorageOptimizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.UpdateTableStorageOptimizerRequest =
      zio.aws.lakeformation.model.UpdateTableStorageOptimizerRequest(
        catalogId.map(value => value),
        databaseName,
        tableName,
        storageOptimizerConfig
      )
    def catalogId: Option[CatalogIdString]
    def databaseName: NameString
    def tableName: NameString
    def storageOptimizerConfig: Map[
      zio.aws.lakeformation.model.OptimizerType,
      Map[StorageOptimizerConfigKey, StorageOptimizerConfigValue]
    ]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, NameString] = ZIO.succeed(tableName)
    def getStorageOptimizerConfig: ZIO[Any, Nothing, Map[
      zio.aws.lakeformation.model.OptimizerType,
      Map[StorageOptimizerConfigKey, StorageOptimizerConfigValue]
    ]] = ZIO.succeed(storageOptimizerConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest
  ) extends zio.aws.lakeformation.model.UpdateTableStorageOptimizerRequest.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.databaseName())
    override val tableName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.tableName())
    override val storageOptimizerConfig: Map[
      zio.aws.lakeformation.model.OptimizerType,
      Map[StorageOptimizerConfigKey, StorageOptimizerConfigValue]
    ] = impl
      .storageOptimizerConfig()
      .asScala
      .map({ case (key, value) =>
        zio.aws.lakeformation.model.OptimizerType.wrap(key) -> value.asScala
          .map({ case (key, value) =>
            zio.aws.lakeformation.model.primitives.StorageOptimizerConfigKey(
              key
            ) -> zio.aws.lakeformation.model.primitives
              .StorageOptimizerConfigValue(value)
          })
          .toMap
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest
  ): zio.aws.lakeformation.model.UpdateTableStorageOptimizerRequest.ReadOnly =
    new Wrapper(impl)
}
