package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.lakeformation.model.primitives.{
  TransactionIdString,
  Timestamp,
  QueryPlanningContextDatabaseNameString,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class QueryPlanningContext(
    catalogId: Option[CatalogIdString] = None,
    databaseName: QueryPlanningContextDatabaseNameString,
    queryAsOfTime: Option[Timestamp] = None,
    queryParameters: Option[Map[String, String]] = None,
    transactionId: Option[TransactionIdString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.QueryPlanningContext = {
    import QueryPlanningContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.QueryPlanningContext
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(
        QueryPlanningContextDatabaseNameString.unwrap(
          databaseName
        ): java.lang.String
      )
      .optionallyWith(
        queryAsOfTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.queryAsOfTime)
      .optionallyWith(
        queryParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.queryParameters)
      .optionallyWith(
        transactionId.map(value =>
          TransactionIdString.unwrap(value): java.lang.String
        )
      )(_.transactionId)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.QueryPlanningContext.ReadOnly =
    zio.aws.lakeformation.model.QueryPlanningContext.wrap(buildAwsValue())
}
object QueryPlanningContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.QueryPlanningContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.QueryPlanningContext =
      zio.aws.lakeformation.model.QueryPlanningContext(
        catalogId.map(value => value),
        databaseName,
        queryAsOfTime.map(value => value),
        queryParameters.map(value => value),
        transactionId.map(value => value)
      )
    def catalogId: Option[CatalogIdString]
    def databaseName: QueryPlanningContextDatabaseNameString
    def queryAsOfTime: Option[Timestamp]
    def queryParameters: Option[Map[String, String]]
    def transactionId: Option[TransactionIdString]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName
        : ZIO[Any, Nothing, QueryPlanningContextDatabaseNameString] =
      ZIO.succeed(databaseName)
    def getQueryAsOfTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("queryAsOfTime", queryAsOfTime)
    def getQueryParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("queryParameters", queryParameters)
    def getTransactionId: ZIO[Any, AwsError, TransactionIdString] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.QueryPlanningContext
  ) extends zio.aws.lakeformation.model.QueryPlanningContext.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: QueryPlanningContextDatabaseNameString =
      zio.aws.lakeformation.model.primitives
        .QueryPlanningContextDatabaseNameString(impl.databaseName())
    override val queryAsOfTime: Option[Timestamp] = scala
      .Option(impl.queryAsOfTime())
      .map(value => zio.aws.lakeformation.model.primitives.Timestamp(value))
    override val queryParameters: Option[Map[String, String]] = scala
      .Option(impl.queryParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val transactionId: Option[TransactionIdString] = scala
      .Option(impl.transactionId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.TransactionIdString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.QueryPlanningContext
  ): zio.aws.lakeformation.model.QueryPlanningContext.ReadOnly = new Wrapper(
    impl
  )
}
