package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.TokenString
import scala.jdk.CollectionConverters._
final case class ListTransactionsResponse(
    transactions: Option[
      Iterable[zio.aws.lakeformation.model.TransactionDescription]
    ] = None,
    nextToken: Option[TokenString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse = {
    import ListTransactionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse
      .builder()
      .optionallyWith(
        transactions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transactions)
      .optionallyWith(
        nextToken.map(value => TokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly =
    zio.aws.lakeformation.model.ListTransactionsResponse.wrap(buildAwsValue())
}
object ListTransactionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListTransactionsResponse =
      zio.aws.lakeformation.model.ListTransactionsResponse(
        transactions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transactions: Option[
      List[zio.aws.lakeformation.model.TransactionDescription.ReadOnly]
    ]
    def nextToken: Option[TokenString]
    def getTransactions: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.TransactionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("transactions", transactions)
    def getNextToken: ZIO[Any, AwsError, TokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse
  ) extends zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly {
    override val transactions: Option[
      List[zio.aws.lakeformation.model.TransactionDescription.ReadOnly]
    ] = scala
      .Option(impl.transactions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.TransactionDescription.wrap(item)
        }.toList
      )
    override val nextToken: Option[TokenString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.TokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse
  ): zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly =
    new Wrapper(impl)
}
