package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListDataCellsFilterResponse(
    dataCellsFilters: Option[
      Iterable[zio.aws.lakeformation.model.DataCellsFilter]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse = {
    import ListDataCellsFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse
      .builder()
      .optionallyWith(
        dataCellsFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataCellsFilters)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly =
    zio.aws.lakeformation.model.ListDataCellsFilterResponse
      .wrap(buildAwsValue())
}
object ListDataCellsFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListDataCellsFilterResponse =
      zio.aws.lakeformation.model.ListDataCellsFilterResponse(
        dataCellsFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataCellsFilters
        : Option[List[zio.aws.lakeformation.model.DataCellsFilter.ReadOnly]]
    def nextToken: Option[Token]
    def getDataCellsFilters: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.DataCellsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("dataCellsFilters", dataCellsFilters)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse
  ) extends zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly {
    override val dataCellsFilters
        : Option[List[zio.aws.lakeformation.model.DataCellsFilter.ReadOnly]] =
      scala
        .Option(impl.dataCellsFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.DataCellsFilter.wrap(item)
          }.toList
        )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse
  ): zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly =
    new Wrapper(impl)
}
