package zio.aws.lakeformation.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  CredentialTimeoutDurationSecondInteger,
  ResourceArnString
}
import scala.jdk.CollectionConverters._
final case class GetTemporaryGlueTableCredentialsRequest(
    tableArn: ResourceArnString,
    permissions: Option[Iterable[zio.aws.lakeformation.model.Permission]] =
      None,
    durationSeconds: Option[CredentialTimeoutDurationSecondInteger] = None,
    auditContext: Option[zio.aws.lakeformation.model.AuditContext] = None,
    supportedPermissionTypes: Iterable[
      zio.aws.lakeformation.model.PermissionType
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest = {
    import GetTemporaryGlueTableCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest
      .builder()
      .tableArn(ResourceArnString.unwrap(tableArn): java.lang.String)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .optionallyWith(
        durationSeconds.map(value =>
          CredentialTimeoutDurationSecondInteger.unwrap(value): Integer
        )
      )(_.durationSeconds)
      .optionallyWith(auditContext.map(value => value.buildAwsValue()))(
        _.auditContext
      )
      .supportedPermissionTypesWithStrings(supportedPermissionTypes.map {
        item =>
          item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsRequest.ReadOnly =
    zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsRequest
      .wrap(buildAwsValue())
}
object GetTemporaryGlueTableCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsRequest =
      zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsRequest(
        tableArn,
        permissions.map(value => value),
        durationSeconds.map(value => value),
        auditContext.map(value => value.asEditable),
        supportedPermissionTypes
      )
    def tableArn: ResourceArnString
    def permissions: Option[List[zio.aws.lakeformation.model.Permission]]
    def durationSeconds: Option[CredentialTimeoutDurationSecondInteger]
    def auditContext: Option[zio.aws.lakeformation.model.AuditContext.ReadOnly]
    def supportedPermissionTypes
        : List[zio.aws.lakeformation.model.PermissionType]
    def getTableArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(tableArn)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getDurationSeconds
        : ZIO[Any, AwsError, CredentialTimeoutDurationSecondInteger] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getAuditContext: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.AuditContext.ReadOnly
    ] = AwsError.unwrapOptionField("auditContext", auditContext)
    def getSupportedPermissionTypes
        : ZIO[Any, Nothing, List[zio.aws.lakeformation.model.PermissionType]] =
      ZIO.succeed(supportedPermissionTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest
  ) extends zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsRequest.ReadOnly {
    override val tableArn: ResourceArnString =
      zio.aws.lakeformation.model.primitives.ResourceArnString(impl.tableArn())
    override val permissions
        : Option[List[zio.aws.lakeformation.model.Permission]] = scala
      .Option(impl.permissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.Permission.wrap(item)
        }.toList
      )
    override val durationSeconds
        : Option[CredentialTimeoutDurationSecondInteger] = scala
      .Option(impl.durationSeconds())
      .map(value =>
        zio.aws.lakeformation.model.primitives
          .CredentialTimeoutDurationSecondInteger(value)
      )
    override val auditContext
        : Option[zio.aws.lakeformation.model.AuditContext.ReadOnly] = scala
      .Option(impl.auditContext())
      .map(value => zio.aws.lakeformation.model.AuditContext.wrap(value))
    override val supportedPermissionTypes
        : List[zio.aws.lakeformation.model.PermissionType] = impl
      .supportedPermissionTypes()
      .asScala
      .map { item =>
        zio.aws.lakeformation.model.PermissionType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest
  ): zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
