package zio.aws.lakeformation
import zio.aws.lakeformation.model.DescribeResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.lakeformation.model.{
  DeleteLfTagRequest,
  RemoveLfTagsFromResourceRequest,
  GetWorkUnitsRequest,
  DeregisterResourceRequest,
  GetTemporaryGluePartitionCredentialsRequest,
  BatchRevokePermissionsRequest,
  GetTableObjectsRequest,
  GetWorkUnitResultsRequest,
  GetTemporaryGlueTableCredentialsRequest,
  SearchTablesByLfTagsRequest,
  GetQueryStatisticsRequest,
  CreateLfTagRequest,
  ListTransactionsRequest,
  AddLfTagsToResourceRequest,
  StartTransactionRequest,
  CommitTransactionRequest,
  StartQueryPlanningRequest,
  RegisterResourceRequest,
  ListTableStorageOptimizersRequest,
  DeleteDataCellsFilterRequest,
  PutDataLakeSettingsRequest,
  ListResourcesRequest,
  UpdateTableObjectsRequest,
  UpdateLfTagRequest,
  ListDataCellsFilterRequest,
  ExtendTransactionRequest,
  GetEffectivePermissionsForPathRequest,
  ListLfTagsRequest,
  GetResourceLfTagsRequest,
  CancelTransactionRequest,
  ListPermissionsRequest,
  SearchDatabasesByLfTagsRequest,
  UpdateTableStorageOptimizerRequest,
  CreateDataCellsFilterRequest,
  GetLfTagRequest,
  GetQueryStateRequest,
  UpdateResourceRequest,
  BatchGrantPermissionsRequest,
  RevokePermissionsRequest,
  DescribeResourceRequest,
  GrantPermissionsRequest,
  GetDataLakeSettingsRequest,
  DeleteObjectsOnCancelRequest,
  DescribeTransactionRequest
}
object LakeFormationMock extends Mock[LakeFormation] {
  object GetResourceLFTags
      extends Effect[
        GetResourceLfTagsRequest,
        AwsError,
        zio.aws.lakeformation.model.GetResourceLfTagsResponse.ReadOnly
      ]
  object ListTransactions
      extends Stream[
        ListTransactionsRequest,
        AwsError,
        zio.aws.lakeformation.model.TransactionDescription.ReadOnly
      ]
  object ListTransactionsPaginated
      extends Effect[
        ListTransactionsRequest,
        AwsError,
        zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly
      ]
  object CommitTransaction
      extends Effect[
        CommitTransactionRequest,
        AwsError,
        zio.aws.lakeformation.model.CommitTransactionResponse.ReadOnly
      ]
  object RemoveLFTagsFromResource
      extends Effect[
        RemoveLfTagsFromResourceRequest,
        AwsError,
        zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse.ReadOnly
      ]
  object UpdateResource
      extends Effect[
        UpdateResourceRequest,
        AwsError,
        zio.aws.lakeformation.model.UpdateResourceResponse.ReadOnly
      ]
  object ListLFTags
      extends Stream[
        ListLfTagsRequest,
        AwsError,
        zio.aws.lakeformation.model.LFTagPair.ReadOnly
      ]
  object ListLFTagsPaginated
      extends Effect[
        ListLfTagsRequest,
        AwsError,
        zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly
      ]
  object RevokePermissions
      extends Effect[
        RevokePermissionsRequest,
        AwsError,
        zio.aws.lakeformation.model.RevokePermissionsResponse.ReadOnly
      ]
  object GrantPermissions
      extends Effect[
        GrantPermissionsRequest,
        AwsError,
        zio.aws.lakeformation.model.GrantPermissionsResponse.ReadOnly
      ]
  object CancelTransaction
      extends Effect[
        CancelTransactionRequest,
        AwsError,
        zio.aws.lakeformation.model.CancelTransactionResponse.ReadOnly
      ]
  object SearchTablesByLFTags
      extends Stream[
        SearchTablesByLfTagsRequest,
        AwsError,
        zio.aws.lakeformation.model.TaggedTable.ReadOnly
      ]
  object SearchTablesByLFTagsPaginated
      extends Effect[
        SearchTablesByLfTagsRequest,
        AwsError,
        zio.aws.lakeformation.model.SearchTablesByLfTagsResponse.ReadOnly
      ]
  object DescribeResource
      extends Effect[DescribeResourceRequest, AwsError, ReadOnly]
  object DeleteObjectsOnCancel
      extends Effect[
        DeleteObjectsOnCancelRequest,
        AwsError,
        zio.aws.lakeformation.model.DeleteObjectsOnCancelResponse.ReadOnly
      ]
  object DescribeTransaction
      extends Effect[
        DescribeTransactionRequest,
        AwsError,
        zio.aws.lakeformation.model.DescribeTransactionResponse.ReadOnly
      ]
  object GetTemporaryGluePartitionCredentials
      extends Effect[
        GetTemporaryGluePartitionCredentialsRequest,
        AwsError,
        zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse.ReadOnly
      ]
  object GetDataLakeSettings
      extends Effect[
        GetDataLakeSettingsRequest,
        AwsError,
        zio.aws.lakeformation.model.GetDataLakeSettingsResponse.ReadOnly
      ]
  object DeleteLFTag
      extends Effect[
        DeleteLfTagRequest,
        AwsError,
        zio.aws.lakeformation.model.DeleteLfTagResponse.ReadOnly
      ]
  object UpdateTableObjects
      extends Effect[
        UpdateTableObjectsRequest,
        AwsError,
        zio.aws.lakeformation.model.UpdateTableObjectsResponse.ReadOnly
      ]
  object StartQueryPlanning
      extends Effect[
        StartQueryPlanningRequest,
        AwsError,
        zio.aws.lakeformation.model.StartQueryPlanningResponse.ReadOnly
      ]
  object GetWorkUnits
      extends Effect[GetWorkUnitsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly,
        zio.aws.lakeformation.model.WorkUnitRange.ReadOnly
      ]]
  object GetWorkUnitsPaginated
      extends Effect[
        GetWorkUnitsRequest,
        AwsError,
        zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly
      ]
  object SearchDatabasesByLFTags
      extends Stream[
        SearchDatabasesByLfTagsRequest,
        AwsError,
        zio.aws.lakeformation.model.TaggedDatabase.ReadOnly
      ]
  object SearchDatabasesByLFTagsPaginated
      extends Effect[
        SearchDatabasesByLfTagsRequest,
        AwsError,
        zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse.ReadOnly
      ]
  object ExtendTransaction
      extends Effect[
        ExtendTransactionRequest,
        AwsError,
        zio.aws.lakeformation.model.ExtendTransactionResponse.ReadOnly
      ]
  object GetWorkUnitResults
      extends Effect[GetWorkUnitResultsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.lakeformation.model.GetWorkUnitResultsResponse.ReadOnly,
        Byte
      ]]
  object ListResources
      extends Stream[
        ListResourcesRequest,
        AwsError,
        zio.aws.lakeformation.model.ResourceInfo.ReadOnly
      ]
  object ListResourcesPaginated
      extends Effect[
        ListResourcesRequest,
        AwsError,
        zio.aws.lakeformation.model.ListResourcesResponse.ReadOnly
      ]
  object PutDataLakeSettings
      extends Effect[
        PutDataLakeSettingsRequest,
        AwsError,
        zio.aws.lakeformation.model.PutDataLakeSettingsResponse.ReadOnly
      ]
  object DeregisterResource
      extends Effect[
        DeregisterResourceRequest,
        AwsError,
        zio.aws.lakeformation.model.DeregisterResourceResponse.ReadOnly
      ]
  object GetTableObjects
      extends Stream[
        GetTableObjectsRequest,
        AwsError,
        zio.aws.lakeformation.model.PartitionObjects.ReadOnly
      ]
  object GetTableObjectsPaginated
      extends Effect[
        GetTableObjectsRequest,
        AwsError,
        zio.aws.lakeformation.model.GetTableObjectsResponse.ReadOnly
      ]
  object CreateDataCellsFilter
      extends Effect[
        CreateDataCellsFilterRequest,
        AwsError,
        zio.aws.lakeformation.model.CreateDataCellsFilterResponse.ReadOnly
      ]
  object ListDataCellsFilter
      extends Stream[
        ListDataCellsFilterRequest,
        AwsError,
        zio.aws.lakeformation.model.DataCellsFilter.ReadOnly
      ]
  object ListDataCellsFilterPaginated
      extends Effect[
        ListDataCellsFilterRequest,
        AwsError,
        zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly
      ]
  object GetTemporaryGlueTableCredentials
      extends Effect[
        GetTemporaryGlueTableCredentialsRequest,
        AwsError,
        zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse.ReadOnly
      ]
  object DeleteDataCellsFilter
      extends Effect[
        DeleteDataCellsFilterRequest,
        AwsError,
        zio.aws.lakeformation.model.DeleteDataCellsFilterResponse.ReadOnly
      ]
  object ListPermissions
      extends Stream[
        ListPermissionsRequest,
        AwsError,
        zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
      ]
  object ListPermissionsPaginated
      extends Effect[
        ListPermissionsRequest,
        AwsError,
        zio.aws.lakeformation.model.ListPermissionsResponse.ReadOnly
      ]
  object CreateLFTag
      extends Effect[
        CreateLfTagRequest,
        AwsError,
        zio.aws.lakeformation.model.CreateLfTagResponse.ReadOnly
      ]
  object UpdateLFTag
      extends Effect[
        UpdateLfTagRequest,
        AwsError,
        zio.aws.lakeformation.model.UpdateLfTagResponse.ReadOnly
      ]
  object UpdateTableStorageOptimizer
      extends Effect[
        UpdateTableStorageOptimizerRequest,
        AwsError,
        zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse.ReadOnly
      ]
  object GetQueryState
      extends Effect[
        GetQueryStateRequest,
        AwsError,
        zio.aws.lakeformation.model.GetQueryStateResponse.ReadOnly
      ]
  object BatchGrantPermissions
      extends Effect[
        BatchGrantPermissionsRequest,
        AwsError,
        zio.aws.lakeformation.model.BatchGrantPermissionsResponse.ReadOnly
      ]
  object AddLFTagsToResource
      extends Effect[
        AddLfTagsToResourceRequest,
        AwsError,
        zio.aws.lakeformation.model.AddLfTagsToResourceResponse.ReadOnly
      ]
  object StartTransaction
      extends Effect[
        StartTransactionRequest,
        AwsError,
        zio.aws.lakeformation.model.StartTransactionResponse.ReadOnly
      ]
  object GetQueryStatistics
      extends Effect[
        GetQueryStatisticsRequest,
        AwsError,
        zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly
      ]
  object GetLFTag
      extends Effect[
        GetLfTagRequest,
        AwsError,
        zio.aws.lakeformation.model.GetLfTagResponse.ReadOnly
      ]
  object RegisterResource
      extends Effect[
        RegisterResourceRequest,
        AwsError,
        zio.aws.lakeformation.model.RegisterResourceResponse.ReadOnly
      ]
  object ListTableStorageOptimizers
      extends Stream[
        ListTableStorageOptimizersRequest,
        AwsError,
        zio.aws.lakeformation.model.StorageOptimizer.ReadOnly
      ]
  object ListTableStorageOptimizersPaginated
      extends Effect[
        ListTableStorageOptimizersRequest,
        AwsError,
        zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly
      ]
  object GetEffectivePermissionsForPath
      extends Stream[
        GetEffectivePermissionsForPathRequest,
        AwsError,
        zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
      ]
  object GetEffectivePermissionsForPathPaginated
      extends Effect[
        GetEffectivePermissionsForPathRequest,
        AwsError,
        zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse.ReadOnly
      ]
  object BatchRevokePermissions
      extends Effect[
        BatchRevokePermissionsRequest,
        AwsError,
        zio.aws.lakeformation.model.BatchRevokePermissionsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, LakeFormation] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new LakeFormation {
          val api: LakeFormationAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : LakeFormation = this
          def getResourceLFTags(request: GetResourceLfTagsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.GetResourceLfTagsResponse.ReadOnly
          ] = proxy(GetResourceLFTags, request)
          def listTransactions(request: ListTransactionsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.lakeformation.model.TransactionDescription.ReadOnly
          ] = rts.unsafeRun(proxy(ListTransactions, request))
          def listTransactionsPaginated(request: ListTransactionsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.ListTransactionsResponse.ReadOnly
          ] = proxy(ListTransactionsPaginated, request)
          def commitTransaction(request: CommitTransactionRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.CommitTransactionResponse.ReadOnly
          ] = proxy(CommitTransaction, request)
          def removeLFTagsFromResource(
              request: RemoveLfTagsFromResourceRequest
          ): IO[
            AwsError,
            zio.aws.lakeformation.model.RemoveLfTagsFromResourceResponse.ReadOnly
          ] = proxy(RemoveLFTagsFromResource, request)
          def updateResource(request: UpdateResourceRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.UpdateResourceResponse.ReadOnly
          ] = proxy(UpdateResource, request)
          def listLFTags(request: ListLfTagsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.lakeformation.model.LFTagPair.ReadOnly
          ] = rts.unsafeRun(proxy(ListLFTags, request))
          def listLFTagsPaginated(request: ListLfTagsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.ListLfTagsResponse.ReadOnly
          ] = proxy(ListLFTagsPaginated, request)
          def revokePermissions(request: RevokePermissionsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.RevokePermissionsResponse.ReadOnly
          ] = proxy(RevokePermissions, request)
          def grantPermissions(request: GrantPermissionsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.GrantPermissionsResponse.ReadOnly
          ] = proxy(GrantPermissions, request)
          def cancelTransaction(request: CancelTransactionRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.CancelTransactionResponse.ReadOnly
          ] = proxy(CancelTransaction, request)
          def searchTablesByLFTags(
              request: SearchTablesByLfTagsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.lakeformation.model.TaggedTable.ReadOnly
          ] = rts.unsafeRun(proxy(SearchTablesByLFTags, request))
          def searchTablesByLFTagsPaginated(
              request: SearchTablesByLfTagsRequest
          ): IO[
            AwsError,
            zio.aws.lakeformation.model.SearchTablesByLfTagsResponse.ReadOnly
          ] = proxy(SearchTablesByLFTagsPaginated, request)
          def describeResource(
              request: DescribeResourceRequest
          ): IO[AwsError, ReadOnly] = proxy(DescribeResource, request)
          def deleteObjectsOnCancel(request: DeleteObjectsOnCancelRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.DeleteObjectsOnCancelResponse.ReadOnly
          ] = proxy(DeleteObjectsOnCancel, request)
          def describeTransaction(request: DescribeTransactionRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.DescribeTransactionResponse.ReadOnly
          ] = proxy(DescribeTransaction, request)
          def getTemporaryGluePartitionCredentials(
              request: GetTemporaryGluePartitionCredentialsRequest
          ): IO[
            AwsError,
            zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse.ReadOnly
          ] = proxy(GetTemporaryGluePartitionCredentials, request)
          def getDataLakeSettings(request: GetDataLakeSettingsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.GetDataLakeSettingsResponse.ReadOnly
          ] = proxy(GetDataLakeSettings, request)
          def deleteLFTag(request: DeleteLfTagRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.DeleteLfTagResponse.ReadOnly
          ] = proxy(DeleteLFTag, request)
          def updateTableObjects(request: UpdateTableObjectsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.UpdateTableObjectsResponse.ReadOnly
          ] = proxy(UpdateTableObjects, request)
          def startQueryPlanning(request: StartQueryPlanningRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.StartQueryPlanningResponse.ReadOnly
          ] = proxy(StartQueryPlanning, request)
          def getWorkUnits(
              request: GetWorkUnitsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly,
            zio.aws.lakeformation.model.WorkUnitRange.ReadOnly
          ]] = proxy(GetWorkUnits, request)
          def getWorkUnitsPaginated(request: GetWorkUnitsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.GetWorkUnitsResponse.ReadOnly
          ] = proxy(GetWorkUnitsPaginated, request)
          def searchDatabasesByLFTags(
              request: SearchDatabasesByLfTagsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.lakeformation.model.TaggedDatabase.ReadOnly
          ] = rts.unsafeRun(proxy(SearchDatabasesByLFTags, request))
          def searchDatabasesByLFTagsPaginated(
              request: SearchDatabasesByLfTagsRequest
          ): IO[
            AwsError,
            zio.aws.lakeformation.model.SearchDatabasesByLfTagsResponse.ReadOnly
          ] = proxy(SearchDatabasesByLFTagsPaginated, request)
          def extendTransaction(request: ExtendTransactionRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.ExtendTransactionResponse.ReadOnly
          ] = proxy(ExtendTransaction, request)
          def getWorkUnitResults(
              request: GetWorkUnitResultsRequest
          ): IO[AwsError, StreamingOutputResult[
            Any,
            zio.aws.lakeformation.model.GetWorkUnitResultsResponse.ReadOnly,
            Byte
          ]] = proxy(GetWorkUnitResults, request)
          def listResources(request: ListResourcesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.lakeformation.model.ResourceInfo.ReadOnly
          ] = rts.unsafeRun(proxy(ListResources, request))
          def listResourcesPaginated(request: ListResourcesRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.ListResourcesResponse.ReadOnly
          ] = proxy(ListResourcesPaginated, request)
          def putDataLakeSettings(request: PutDataLakeSettingsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.PutDataLakeSettingsResponse.ReadOnly
          ] = proxy(PutDataLakeSettings, request)
          def deregisterResource(request: DeregisterResourceRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.DeregisterResourceResponse.ReadOnly
          ] = proxy(DeregisterResource, request)
          def getTableObjects(request: GetTableObjectsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.lakeformation.model.PartitionObjects.ReadOnly
          ] = rts.unsafeRun(proxy(GetTableObjects, request))
          def getTableObjectsPaginated(request: GetTableObjectsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.GetTableObjectsResponse.ReadOnly
          ] = proxy(GetTableObjectsPaginated, request)
          def createDataCellsFilter(request: CreateDataCellsFilterRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.CreateDataCellsFilterResponse.ReadOnly
          ] = proxy(CreateDataCellsFilter, request)
          def listDataCellsFilter(request: ListDataCellsFilterRequest): ZStream[
            Any,
            AwsError,
            zio.aws.lakeformation.model.DataCellsFilter.ReadOnly
          ] = rts.unsafeRun(proxy(ListDataCellsFilter, request))
          def listDataCellsFilterPaginated(
              request: ListDataCellsFilterRequest
          ): IO[
            AwsError,
            zio.aws.lakeformation.model.ListDataCellsFilterResponse.ReadOnly
          ] = proxy(ListDataCellsFilterPaginated, request)
          def getTemporaryGlueTableCredentials(
              request: GetTemporaryGlueTableCredentialsRequest
          ): IO[
            AwsError,
            zio.aws.lakeformation.model.GetTemporaryGlueTableCredentialsResponse.ReadOnly
          ] = proxy(GetTemporaryGlueTableCredentials, request)
          def deleteDataCellsFilter(request: DeleteDataCellsFilterRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.DeleteDataCellsFilterResponse.ReadOnly
          ] = proxy(DeleteDataCellsFilter, request)
          def listPermissions(request: ListPermissionsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
          ] = rts.unsafeRun(proxy(ListPermissions, request))
          def listPermissionsPaginated(request: ListPermissionsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.ListPermissionsResponse.ReadOnly
          ] = proxy(ListPermissionsPaginated, request)
          def createLFTag(request: CreateLfTagRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.CreateLfTagResponse.ReadOnly
          ] = proxy(CreateLFTag, request)
          def updateLFTag(request: UpdateLfTagRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.UpdateLfTagResponse.ReadOnly
          ] = proxy(UpdateLFTag, request)
          def updateTableStorageOptimizer(
              request: UpdateTableStorageOptimizerRequest
          ): IO[
            AwsError,
            zio.aws.lakeformation.model.UpdateTableStorageOptimizerResponse.ReadOnly
          ] = proxy(UpdateTableStorageOptimizer, request)
          def getQueryState(request: GetQueryStateRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.GetQueryStateResponse.ReadOnly
          ] = proxy(GetQueryState, request)
          def batchGrantPermissions(request: BatchGrantPermissionsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.BatchGrantPermissionsResponse.ReadOnly
          ] = proxy(BatchGrantPermissions, request)
          def addLFTagsToResource(request: AddLfTagsToResourceRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.AddLfTagsToResourceResponse.ReadOnly
          ] = proxy(AddLFTagsToResource, request)
          def startTransaction(request: StartTransactionRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.StartTransactionResponse.ReadOnly
          ] = proxy(StartTransaction, request)
          def getQueryStatistics(request: GetQueryStatisticsRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.GetQueryStatisticsResponse.ReadOnly
          ] = proxy(GetQueryStatistics, request)
          def getLFTag(request: GetLfTagRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.GetLfTagResponse.ReadOnly
          ] = proxy(GetLFTag, request)
          def registerResource(request: RegisterResourceRequest): IO[
            AwsError,
            zio.aws.lakeformation.model.RegisterResourceResponse.ReadOnly
          ] = proxy(RegisterResource, request)
          def listTableStorageOptimizers(
              request: ListTableStorageOptimizersRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.lakeformation.model.StorageOptimizer.ReadOnly
          ] = rts.unsafeRun(proxy(ListTableStorageOptimizers, request))
          def listTableStorageOptimizersPaginated(
              request: ListTableStorageOptimizersRequest
          ): IO[
            AwsError,
            zio.aws.lakeformation.model.ListTableStorageOptimizersResponse.ReadOnly
          ] = proxy(ListTableStorageOptimizersPaginated, request)
          def getEffectivePermissionsForPath(
              request: GetEffectivePermissionsForPathRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
          ] = rts.unsafeRun(proxy(GetEffectivePermissionsForPath, request))
          def getEffectivePermissionsForPathPaginated(
              request: GetEffectivePermissionsForPathRequest
          ): IO[
            AwsError,
            zio.aws.lakeformation.model.GetEffectivePermissionsForPathResponse.ReadOnly
          ] = proxy(GetEffectivePermissionsForPathPaginated, request)
          def batchRevokePermissions(
              request: BatchRevokePermissionsRequest
          ): IO[
            AwsError,
            zio.aws.lakeformation.model.BatchRevokePermissionsResponse.ReadOnly
          ] = proxy(BatchRevokePermissions, request)
        }
      }
    }
    .toLayer
}
