package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TaggedTable(
    table: Option[zio.aws.lakeformation.model.TableResource] = None,
    lfTagOnDatabase: Option[Iterable[zio.aws.lakeformation.model.LFTagPair]] =
      None,
    lfTagsOnTable: Option[Iterable[zio.aws.lakeformation.model.LFTagPair]] =
      None,
    lfTagsOnColumns: Option[Iterable[zio.aws.lakeformation.model.ColumnLFTag]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.TaggedTable = {
    import TaggedTable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.TaggedTable
      .builder()
      .optionallyWith(table.map(value => value.buildAwsValue()))(_.table)
      .optionallyWith(
        lfTagOnDatabase.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lfTagOnDatabase)
      .optionallyWith(
        lfTagsOnTable.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lfTagsOnTable)
      .optionallyWith(
        lfTagsOnColumns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lfTagsOnColumns)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.TaggedTable.ReadOnly =
    zio.aws.lakeformation.model.TaggedTable.wrap(buildAwsValue())
}
object TaggedTable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.TaggedTable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.TaggedTable =
      zio.aws.lakeformation.model.TaggedTable(
        table.map(value => value.asEditable),
        lfTagOnDatabase.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lfTagsOnTable.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lfTagsOnColumns.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def table: Option[zio.aws.lakeformation.model.TableResource.ReadOnly]
    def lfTagOnDatabase
        : Option[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]]
    def lfTagsOnTable
        : Option[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]]
    def lfTagsOnColumns
        : Option[List[zio.aws.lakeformation.model.ColumnLFTag.ReadOnly]]
    def getTable: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.TableResource.ReadOnly
    ] = AwsError.unwrapOptionField("table", table)
    def getLfTagOnDatabase: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.LFTagPair.ReadOnly
    ]] = AwsError.unwrapOptionField("lfTagOnDatabase", lfTagOnDatabase)
    def getLfTagsOnTable: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.LFTagPair.ReadOnly
    ]] = AwsError.unwrapOptionField("lfTagsOnTable", lfTagsOnTable)
    def getLfTagsOnColumns: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.ColumnLFTag.ReadOnly
    ]] = AwsError.unwrapOptionField("lfTagsOnColumns", lfTagsOnColumns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.TaggedTable
  ) extends zio.aws.lakeformation.model.TaggedTable.ReadOnly {
    override val table
        : Option[zio.aws.lakeformation.model.TableResource.ReadOnly] = scala
      .Option(impl.table())
      .map(value => zio.aws.lakeformation.model.TableResource.wrap(value))
    override val lfTagOnDatabase
        : Option[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]] = scala
      .Option(impl.lfTagOnDatabase())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.LFTagPair.wrap(item)
        }.toList
      )
    override val lfTagsOnTable
        : Option[List[zio.aws.lakeformation.model.LFTagPair.ReadOnly]] = scala
      .Option(impl.lfTagsOnTable())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.LFTagPair.wrap(item)
        }.toList
      )
    override val lfTagsOnColumns
        : Option[List[zio.aws.lakeformation.model.ColumnLFTag.ReadOnly]] = scala
      .Option(impl.lfTagsOnColumns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.ColumnLFTag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.TaggedTable
  ): zio.aws.lakeformation.model.TaggedTable.ReadOnly = new Wrapper(impl)
}
