package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PrincipalResourcePermissions(
    principal: Option[zio.aws.lakeformation.model.DataLakePrincipal] = None,
    resource: Option[zio.aws.lakeformation.model.Resource] = None,
    permissions: Option[Iterable[zio.aws.lakeformation.model.Permission]] =
      None,
    permissionsWithGrantOption: Option[
      Iterable[zio.aws.lakeformation.model.Permission]
    ] = None,
    additionalDetails: Option[zio.aws.lakeformation.model.DetailsMap] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions = {
    import PrincipalResourcePermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions
      .builder()
      .optionallyWith(principal.map(value => value.buildAwsValue()))(
        _.principal
      )
      .optionallyWith(resource.map(value => value.buildAwsValue()))(_.resource)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .optionallyWith(
        permissionsWithGrantOption.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithGrantOptionWithStrings)
      .optionallyWith(additionalDetails.map(value => value.buildAwsValue()))(
        _.additionalDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly =
    zio.aws.lakeformation.model.PrincipalResourcePermissions
      .wrap(buildAwsValue())
}
object PrincipalResourcePermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.PrincipalResourcePermissions =
      zio.aws.lakeformation.model.PrincipalResourcePermissions(
        principal.map(value => value.asEditable),
        resource.map(value => value.asEditable),
        permissions.map(value => value),
        permissionsWithGrantOption.map(value => value),
        additionalDetails.map(value => value.asEditable)
      )
    def principal
        : Option[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]
    def resource: Option[zio.aws.lakeformation.model.Resource.ReadOnly]
    def permissions: Option[List[zio.aws.lakeformation.model.Permission]]
    def permissionsWithGrantOption
        : Option[List[zio.aws.lakeformation.model.Permission]]
    def additionalDetails
        : Option[zio.aws.lakeformation.model.DetailsMap.ReadOnly]
    def getPrincipal: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ] = AwsError.unwrapOptionField("principal", principal)
    def getResource
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.Resource.ReadOnly] =
      AwsError.unwrapOptionField("resource", resource)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getPermissionsWithGrantOption
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField(
        "permissionsWithGrantOption",
        permissionsWithGrantOption
      )
    def getAdditionalDetails
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.DetailsMap.ReadOnly] =
      AwsError.unwrapOptionField("additionalDetails", additionalDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions
  ) extends zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly {
    override val principal
        : Option[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly] = scala
      .Option(impl.principal())
      .map(value => zio.aws.lakeformation.model.DataLakePrincipal.wrap(value))
    override val resource
        : Option[zio.aws.lakeformation.model.Resource.ReadOnly] = scala
      .Option(impl.resource())
      .map(value => zio.aws.lakeformation.model.Resource.wrap(value))
    override val permissions
        : Option[List[zio.aws.lakeformation.model.Permission]] = scala
      .Option(impl.permissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.Permission.wrap(item)
        }.toList
      )
    override val permissionsWithGrantOption
        : Option[List[zio.aws.lakeformation.model.Permission]] = scala
      .Option(impl.permissionsWithGrantOption())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.Permission.wrap(item)
        }.toList
      )
    override val additionalDetails
        : Option[zio.aws.lakeformation.model.DetailsMap.ReadOnly] = scala
      .Option(impl.additionalDetails())
      .map(value => zio.aws.lakeformation.model.DetailsMap.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions
  ): zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly =
    new Wrapper(impl)
}
