package zio.aws.lakeformation.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  Token,
  PageSize,
  NameString,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class ListTableStorageOptimizersRequest(
    catalogId: Option[CatalogIdString] = None,
    databaseName: NameString,
    tableName: NameString,
    storageOptimizerType: Option[zio.aws.lakeformation.model.OptimizerType] =
      None,
    maxResults: Option[PageSize] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest = {
    import ListTableStorageOptimizersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .tableName(NameString.unwrap(tableName): java.lang.String)
      .optionallyWith(storageOptimizerType.map(value => value.unwrap))(
        _.storageOptimizerType
      )
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.ListTableStorageOptimizersRequest.ReadOnly =
    zio.aws.lakeformation.model.ListTableStorageOptimizersRequest
      .wrap(buildAwsValue())
}
object ListTableStorageOptimizersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.ListTableStorageOptimizersRequest =
      zio.aws.lakeformation.model.ListTableStorageOptimizersRequest(
        catalogId.map(value => value),
        databaseName,
        tableName,
        storageOptimizerType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def catalogId: Option[CatalogIdString]
    def databaseName: NameString
    def tableName: NameString
    def storageOptimizerType: Option[zio.aws.lakeformation.model.OptimizerType]
    def maxResults: Option[PageSize]
    def nextToken: Option[Token]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, NameString] = ZIO.succeed(tableName)
    def getStorageOptimizerType
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.OptimizerType] =
      AwsError.unwrapOptionField("storageOptimizerType", storageOptimizerType)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest
  ) extends zio.aws.lakeformation.model.ListTableStorageOptimizersRequest.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.databaseName())
    override val tableName: NameString =
      zio.aws.lakeformation.model.primitives.NameString(impl.tableName())
    override val storageOptimizerType
        : Option[zio.aws.lakeformation.model.OptimizerType] = scala
      .Option(impl.storageOptimizerType())
      .map(value => zio.aws.lakeformation.model.OptimizerType.wrap(value))
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest
  ): zio.aws.lakeformation.model.ListTableStorageOptimizersRequest.ReadOnly =
    new Wrapper(impl)
}
