package zio.aws.lakeformation.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{Token, PageSize}
import scala.jdk.CollectionConverters._
final case class ListResourcesRequest(
    filterConditionList: Option[
      Iterable[zio.aws.lakeformation.model.FilterCondition]
    ] = None,
    maxResults: Option[PageSize] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest = {
    import ListResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest
      .builder()
      .optionallyWith(
        filterConditionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filterConditionList)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListResourcesRequest.ReadOnly =
    zio.aws.lakeformation.model.ListResourcesRequest.wrap(buildAwsValue())
}
object ListResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListResourcesRequest =
      zio.aws.lakeformation.model.ListResourcesRequest(
        filterConditionList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filterConditionList
        : Option[List[zio.aws.lakeformation.model.FilterCondition.ReadOnly]]
    def maxResults: Option[PageSize]
    def nextToken: Option[Token]
    def getFilterConditionList: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.FilterCondition.ReadOnly
    ]] = AwsError.unwrapOptionField("filterConditionList", filterConditionList)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest
  ) extends zio.aws.lakeformation.model.ListResourcesRequest.ReadOnly {
    override val filterConditionList
        : Option[List[zio.aws.lakeformation.model.FilterCondition.ReadOnly]] =
      scala
        .Option(impl.filterConditionList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.FilterCondition.wrap(item)
          }.toList
        )
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest
  ): zio.aws.lakeformation.model.ListResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
