package zio.aws.lakeformation.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  TrueFalseString,
  PageSize,
  Token,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class ListPermissionsRequest(
    catalogId: Option[CatalogIdString] = None,
    principal: Option[zio.aws.lakeformation.model.DataLakePrincipal] = None,
    resourceType: Option[zio.aws.lakeformation.model.DataLakeResourceType] =
      None,
    resource: Option[zio.aws.lakeformation.model.Resource] = None,
    nextToken: Option[Token] = None,
    maxResults: Option[PageSize] = None,
    includeRelated: Option[TrueFalseString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest = {
    import ListPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest
      .builder()
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .optionallyWith(principal.map(value => value.buildAwsValue()))(
        _.principal
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resource.map(value => value.buildAwsValue()))(_.resource)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        includeRelated.map(value =>
          TrueFalseString.unwrap(value): java.lang.String
        )
      )(_.includeRelated)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListPermissionsRequest.ReadOnly =
    zio.aws.lakeformation.model.ListPermissionsRequest.wrap(buildAwsValue())
}
object ListPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListPermissionsRequest =
      zio.aws.lakeformation.model.ListPermissionsRequest(
        catalogId.map(value => value),
        principal.map(value => value.asEditable),
        resourceType.map(value => value),
        resource.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value),
        includeRelated.map(value => value)
      )
    def catalogId: Option[CatalogIdString]
    def principal
        : Option[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]
    def resourceType: Option[zio.aws.lakeformation.model.DataLakeResourceType]
    def resource: Option[zio.aws.lakeformation.model.Resource.ReadOnly]
    def nextToken: Option[Token]
    def maxResults: Option[PageSize]
    def includeRelated: Option[TrueFalseString]
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getPrincipal: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ] = AwsError.unwrapOptionField("principal", principal)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.DataLakeResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResource
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.Resource.ReadOnly] =
      AwsError.unwrapOptionField("resource", resource)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getIncludeRelated: ZIO[Any, AwsError, TrueFalseString] =
      AwsError.unwrapOptionField("includeRelated", includeRelated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest
  ) extends zio.aws.lakeformation.model.ListPermissionsRequest.ReadOnly {
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val principal
        : Option[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly] = scala
      .Option(impl.principal())
      .map(value => zio.aws.lakeformation.model.DataLakePrincipal.wrap(value))
    override val resourceType
        : Option[zio.aws.lakeformation.model.DataLakeResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.lakeformation.model.DataLakeResourceType.wrap(value)
      )
    override val resource
        : Option[zio.aws.lakeformation.model.Resource.ReadOnly] = scala
      .Option(impl.resource())
      .map(value => zio.aws.lakeformation.model.Resource.wrap(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val includeRelated: Option[TrueFalseString] = scala
      .Option(impl.includeRelated())
      .map(value =>
        zio.aws.lakeformation.model.primitives.TrueFalseString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest
  ): zio.aws.lakeformation.model.ListPermissionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
