package zio.aws.lakeformation.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  CredentialTimeoutDurationSecondInteger,
  ResourceArnString
}
import scala.jdk.CollectionConverters._
final case class GetTemporaryGluePartitionCredentialsRequest(
    tableArn: ResourceArnString,
    partition: zio.aws.lakeformation.model.PartitionValueList,
    permissions: Option[Iterable[zio.aws.lakeformation.model.Permission]] =
      None,
    durationSeconds: Option[CredentialTimeoutDurationSecondInteger] = None,
    auditContext: Option[zio.aws.lakeformation.model.AuditContext] = None,
    supportedPermissionTypes: Iterable[
      zio.aws.lakeformation.model.PermissionType
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest = {
    import GetTemporaryGluePartitionCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest
      .builder()
      .tableArn(ResourceArnString.unwrap(tableArn): java.lang.String)
      .partition(partition.buildAwsValue())
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .optionallyWith(
        durationSeconds.map(value =>
          CredentialTimeoutDurationSecondInteger.unwrap(value): Integer
        )
      )(_.durationSeconds)
      .optionallyWith(auditContext.map(value => value.buildAwsValue()))(
        _.auditContext
      )
      .supportedPermissionTypesWithStrings(supportedPermissionTypes.map {
        item =>
          item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest.ReadOnly =
    zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest
      .wrap(buildAwsValue())
}
object GetTemporaryGluePartitionCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest =
      zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest(
        tableArn,
        partition.asEditable,
        permissions.map(value => value),
        durationSeconds.map(value => value),
        auditContext.map(value => value.asEditable),
        supportedPermissionTypes
      )
    def tableArn: ResourceArnString
    def partition: zio.aws.lakeformation.model.PartitionValueList.ReadOnly
    def permissions: Option[List[zio.aws.lakeformation.model.Permission]]
    def durationSeconds: Option[CredentialTimeoutDurationSecondInteger]
    def auditContext: Option[zio.aws.lakeformation.model.AuditContext.ReadOnly]
    def supportedPermissionTypes
        : List[zio.aws.lakeformation.model.PermissionType]
    def getTableArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(tableArn)
    def getPartition: ZIO[
      Any,
      Nothing,
      zio.aws.lakeformation.model.PartitionValueList.ReadOnly
    ] = ZIO.succeed(partition)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getDurationSeconds
        : ZIO[Any, AwsError, CredentialTimeoutDurationSecondInteger] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getAuditContext: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.AuditContext.ReadOnly
    ] = AwsError.unwrapOptionField("auditContext", auditContext)
    def getSupportedPermissionTypes
        : ZIO[Any, Nothing, List[zio.aws.lakeformation.model.PermissionType]] =
      ZIO.succeed(supportedPermissionTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest
  ) extends zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest.ReadOnly {
    override val tableArn: ResourceArnString =
      zio.aws.lakeformation.model.primitives.ResourceArnString(impl.tableArn())
    override val partition
        : zio.aws.lakeformation.model.PartitionValueList.ReadOnly =
      zio.aws.lakeformation.model.PartitionValueList.wrap(impl.partition())
    override val permissions
        : Option[List[zio.aws.lakeformation.model.Permission]] = scala
      .Option(impl.permissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.Permission.wrap(item)
        }.toList
      )
    override val durationSeconds
        : Option[CredentialTimeoutDurationSecondInteger] = scala
      .Option(impl.durationSeconds())
      .map(value =>
        zio.aws.lakeformation.model.primitives
          .CredentialTimeoutDurationSecondInteger(value)
      )
    override val auditContext
        : Option[zio.aws.lakeformation.model.AuditContext.ReadOnly] = scala
      .Option(impl.auditContext())
      .map(value => zio.aws.lakeformation.model.AuditContext.wrap(value))
    override val supportedPermissionTypes
        : List[zio.aws.lakeformation.model.PermissionType] = impl
      .supportedPermissionTypes()
      .asScala
      .map { item =>
        zio.aws.lakeformation.model.PermissionType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest
  ): zio.aws.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
