package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{NameString, CatalogIdString}
import scala.jdk.CollectionConverters._
final case class DataCellsFilterResource(
    tableCatalogId: Option[CatalogIdString] = None,
    databaseName: Option[NameString] = None,
    tableName: Option[NameString] = None,
    name: Option[NameString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource = {
    import DataCellsFilterResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource
      .builder()
      .optionallyWith(
        tableCatalogId.map(value =>
          CatalogIdString.unwrap(value): java.lang.String
        )
      )(_.tableCatalogId)
      .optionallyWith(
        databaseName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        tableName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        name.map(value => NameString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly =
    zio.aws.lakeformation.model.DataCellsFilterResource.wrap(buildAwsValue())
}
object DataCellsFilterResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DataCellsFilterResource =
      zio.aws.lakeformation.model.DataCellsFilterResource(
        tableCatalogId.map(value => value),
        databaseName.map(value => value),
        tableName.map(value => value),
        name.map(value => value)
      )
    def tableCatalogId: Option[CatalogIdString]
    def databaseName: Option[NameString]
    def tableName: Option[NameString]
    def name: Option[NameString]
    def getTableCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("tableCatalogId", tableCatalogId)
    def getDatabaseName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getTableName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource
  ) extends zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly {
    override val tableCatalogId: Option[CatalogIdString] = scala
      .Option(impl.tableCatalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val databaseName: Option[NameString] = scala
      .Option(impl.databaseName())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
    override val tableName: Option[NameString] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
    override val name: Option[NameString] = scala
      .Option(impl.name())
      .map(value => zio.aws.lakeformation.model.primitives.NameString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource
  ): zio.aws.lakeformation.model.DataCellsFilterResource.ReadOnly = new Wrapper(
    impl
  )
}
