package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.Identifier
import scala.jdk.CollectionConverters._
final case class BatchPermissionsRequestEntry(
    id: Identifier,
    principal: Option[zio.aws.lakeformation.model.DataLakePrincipal] = None,
    resource: Option[zio.aws.lakeformation.model.Resource] = None,
    permissions: Option[Iterable[zio.aws.lakeformation.model.Permission]] =
      None,
    permissionsWithGrantOption: Option[
      Iterable[zio.aws.lakeformation.model.Permission]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry = {
    import BatchPermissionsRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry
      .builder()
      .id(Identifier.unwrap(id): java.lang.String)
      .optionallyWith(principal.map(value => value.buildAwsValue()))(
        _.principal
      )
      .optionallyWith(resource.map(value => value.buildAwsValue()))(_.resource)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .optionallyWith(
        permissionsWithGrantOption.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithGrantOptionWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly =
    zio.aws.lakeformation.model.BatchPermissionsRequestEntry
      .wrap(buildAwsValue())
}
object BatchPermissionsRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.BatchPermissionsRequestEntry =
      zio.aws.lakeformation.model.BatchPermissionsRequestEntry(
        id,
        principal.map(value => value.asEditable),
        resource.map(value => value.asEditable),
        permissions.map(value => value),
        permissionsWithGrantOption.map(value => value)
      )
    def id: Identifier
    def principal
        : Option[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]
    def resource: Option[zio.aws.lakeformation.model.Resource.ReadOnly]
    def permissions: Option[List[zio.aws.lakeformation.model.Permission]]
    def permissionsWithGrantOption
        : Option[List[zio.aws.lakeformation.model.Permission]]
    def getId: ZIO[Any, Nothing, Identifier] = ZIO.succeed(id)
    def getPrincipal: ZIO[
      Any,
      AwsError,
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ] = AwsError.unwrapOptionField("principal", principal)
    def getResource
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.Resource.ReadOnly] =
      AwsError.unwrapOptionField("resource", resource)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getPermissionsWithGrantOption
        : ZIO[Any, AwsError, List[zio.aws.lakeformation.model.Permission]] =
      AwsError.unwrapOptionField(
        "permissionsWithGrantOption",
        permissionsWithGrantOption
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry
  ) extends zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly {
    override val id: Identifier =
      zio.aws.lakeformation.model.primitives.Identifier(impl.id())
    override val principal
        : Option[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly] = scala
      .Option(impl.principal())
      .map(value => zio.aws.lakeformation.model.DataLakePrincipal.wrap(value))
    override val resource
        : Option[zio.aws.lakeformation.model.Resource.ReadOnly] = scala
      .Option(impl.resource())
      .map(value => zio.aws.lakeformation.model.Resource.wrap(value))
    override val permissions
        : Option[List[zio.aws.lakeformation.model.Permission]] = scala
      .Option(impl.permissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.Permission.wrap(item)
        }.toList
      )
    override val permissionsWithGrantOption
        : Option[List[zio.aws.lakeformation.model.Permission]] = scala
      .Option(impl.permissionsWithGrantOption())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.Permission.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry
  ): zio.aws.lakeformation.model.BatchPermissionsRequestEntry.ReadOnly =
    new Wrapper(impl)
}
