package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait TransactionStatus {
  def unwrap
      : software.amazon.awssdk.services.lakeformation.model.TransactionStatus
}
object TransactionStatus {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.TransactionStatus
  ): zio.aws.lakeformation.model.TransactionStatus = value match {
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatus.COMMITTED =>
      val r = COMMITTED
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatus.ABORTED =>
      val r = ABORTED
      r
    case software.amazon.awssdk.services.lakeformation.model.TransactionStatus.COMMIT_IN_PROGRESS =>
      val r = COMMIT_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.TransactionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatus =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.lakeformation.model.TransactionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatus =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatus.ACTIVE
  }
  case object COMMITTED extends zio.aws.lakeformation.model.TransactionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatus =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatus.COMMITTED
  }
  case object ABORTED extends zio.aws.lakeformation.model.TransactionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatus =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatus.ABORTED
  }
  case object COMMIT_IN_PROGRESS
      extends zio.aws.lakeformation.model.TransactionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.TransactionStatus =
      software.amazon.awssdk.services.lakeformation.model.TransactionStatus.COMMIT_IN_PROGRESS
  }
}
