package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartTransactionRequest(
    transactionType: Option[zio.aws.lakeformation.model.TransactionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest = {
    import StartTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest
      .builder()
      .optionallyWith(transactionType.map(value => value.unwrap))(
        _.transactionType
      )
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.StartTransactionRequest.ReadOnly =
    zio.aws.lakeformation.model.StartTransactionRequest.wrap(buildAwsValue())
}
object StartTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.StartTransactionRequest =
      zio.aws.lakeformation.model
        .StartTransactionRequest(transactionType.map(value => value))
    def transactionType: Option[zio.aws.lakeformation.model.TransactionType]
    def getTransactionType
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.TransactionType] =
      AwsError.unwrapOptionField("transactionType", transactionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest
  ) extends zio.aws.lakeformation.model.StartTransactionRequest.ReadOnly {
    override val transactionType
        : Option[zio.aws.lakeformation.model.TransactionType] = scala
      .Option(impl.transactionType())
      .map(value => zio.aws.lakeformation.model.TransactionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest
  ): zio.aws.lakeformation.model.StartTransactionRequest.ReadOnly = new Wrapper(
    impl
  )
}
