package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class SearchTablesByLfTagsResponse(
    nextToken: Option[Token] = None,
    tableList: Option[Iterable[zio.aws.lakeformation.model.TaggedTable]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse = {
    import SearchTablesByLfTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tableList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tableList)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.SearchTablesByLfTagsResponse.ReadOnly =
    zio.aws.lakeformation.model.SearchTablesByLfTagsResponse
      .wrap(buildAwsValue())
}
object SearchTablesByLfTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.SearchTablesByLfTagsResponse =
      zio.aws.lakeformation.model.SearchTablesByLfTagsResponse(
        nextToken.map(value => value),
        tableList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[Token]
    def tableList
        : Option[List[zio.aws.lakeformation.model.TaggedTable.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTableList: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.TaggedTable.ReadOnly
    ]] = AwsError.unwrapOptionField("tableList", tableList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse
  ) extends zio.aws.lakeformation.model.SearchTablesByLfTagsResponse.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
    override val tableList
        : Option[List[zio.aws.lakeformation.model.TaggedTable.ReadOnly]] = scala
      .Option(impl.tableList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.TaggedTable.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse
  ): zio.aws.lakeformation.model.SearchTablesByLfTagsResponse.ReadOnly =
    new Wrapper(impl)
}
