package zio.aws.lakeformation.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{CatalogIdString, PageSize, Token}
import scala.jdk.CollectionConverters._
final case class SearchDatabasesByLfTagsRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[PageSize] = None,
    catalogId: Option[CatalogIdString] = None,
    expression: Iterable[zio.aws.lakeformation.model.LFTag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest = {
    import SearchDatabasesByLfTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        catalogId.map(value => CatalogIdString.unwrap(value): java.lang.String)
      )(_.catalogId)
      .expression(expression.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest.ReadOnly =
    zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest
      .wrap(buildAwsValue())
}
object SearchDatabasesByLfTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest =
      zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        catalogId.map(value => value),
        expression.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[Token]
    def maxResults: Option[PageSize]
    def catalogId: Option[CatalogIdString]
    def expression: List[zio.aws.lakeformation.model.LFTag.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCatalogId: ZIO[Any, AwsError, CatalogIdString] =
      AwsError.unwrapOptionField("catalogId", catalogId)
    def getExpression
        : ZIO[Any, Nothing, List[zio.aws.lakeformation.model.LFTag.ReadOnly]] =
      ZIO.succeed(expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest
  ) extends zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lakeformation.model.primitives.PageSize(value))
    override val catalogId: Option[CatalogIdString] = scala
      .Option(impl.catalogId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.CatalogIdString(value)
      )
    override val expression: List[zio.aws.lakeformation.model.LFTag.ReadOnly] =
      impl
        .expression()
        .asScala
        .map { item =>
          zio.aws.lakeformation.model.LFTag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest
  ): zio.aws.lakeformation.model.SearchDatabasesByLfTagsRequest.ReadOnly =
    new Wrapper(impl)
}
