package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait Permission {
  def unwrap: software.amazon.awssdk.services.lakeformation.model.Permission
}
object Permission {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.Permission
  ): zio.aws.lakeformation.model.Permission = value match {
    case software.amazon.awssdk.services.lakeformation.model.Permission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.SELECT =>
      val r = SELECT
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.ALTER =>
      val r = ALTER
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.DROP =>
      val r = DROP
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.DELETE =>
      val r = DELETE
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.INSERT =>
      val r = INSERT
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.DESCRIBE =>
      val r = DESCRIBE
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.CREATE_DATABASE =>
      val r = CREATE_DATABASE
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.CREATE_TABLE =>
      val r = CREATE_TABLE
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.DATA_LOCATION_ACCESS =>
      val r = DATA_LOCATION_ACCESS
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.CREATE_TAG =>
      val r = CREATE_TAG
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.ALTER_TAG =>
      val r = ALTER_TAG
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.DELETE_TAG =>
      val r = DELETE_TAG
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.DESCRIBE_TAG =>
      val r = DESCRIBE_TAG
      r
    case software.amazon.awssdk.services.lakeformation.model.Permission.ASSOCIATE_TAG =>
      val r = ASSOCIATE_TAG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.ALL
  }
  case object SELECT extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.SELECT
  }
  case object ALTER extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.ALTER
  }
  case object DROP extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.DROP
  }
  case object DELETE extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.DELETE
  }
  case object INSERT extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.INSERT
  }
  case object DESCRIBE extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.DESCRIBE
  }
  case object CREATE_DATABASE extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.CREATE_DATABASE
  }
  case object CREATE_TABLE extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.CREATE_TABLE
  }
  case object DATA_LOCATION_ACCESS
      extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.DATA_LOCATION_ACCESS
  }
  case object CREATE_TAG extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.CREATE_TAG
  }
  case object ALTER_TAG extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.ALTER_TAG
  }
  case object DELETE_TAG extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.DELETE_TAG
  }
  case object DESCRIBE_TAG extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.DESCRIBE_TAG
  }
  case object ASSOCIATE_TAG extends zio.aws.lakeformation.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.Permission =
      software.amazon.awssdk.services.lakeformation.model.Permission.ASSOCIATE_TAG
  }
}
