package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.StringValue
import scala.jdk.CollectionConverters._
final case class FilterCondition(
    field: Option[zio.aws.lakeformation.model.FieldNameString] = None,
    comparisonOperator: Option[zio.aws.lakeformation.model.ComparisonOperator] =
      None,
    stringValueList: Option[Iterable[StringValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.FilterCondition = {
    import FilterCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.FilterCondition
      .builder()
      .optionallyWith(field.map(value => value.unwrap))(_.field)
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(
        stringValueList.map(value =>
          value.map { item =>
            StringValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stringValueList)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.FilterCondition.ReadOnly =
    zio.aws.lakeformation.model.FilterCondition.wrap(buildAwsValue())
}
object FilterCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.FilterCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.FilterCondition =
      zio.aws.lakeformation.model.FilterCondition(
        field.map(value => value),
        comparisonOperator.map(value => value),
        stringValueList.map(value => value)
      )
    def field: Option[zio.aws.lakeformation.model.FieldNameString]
    def comparisonOperator
        : Option[zio.aws.lakeformation.model.ComparisonOperator]
    def stringValueList: Option[List[StringValue]]
    def getField
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.FieldNameString] =
      AwsError.unwrapOptionField("field", field)
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.lakeformation.model.ComparisonOperator] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getStringValueList: ZIO[Any, AwsError, List[StringValue]] =
      AwsError.unwrapOptionField("stringValueList", stringValueList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.FilterCondition
  ) extends zio.aws.lakeformation.model.FilterCondition.ReadOnly {
    override val field: Option[zio.aws.lakeformation.model.FieldNameString] =
      scala
        .Option(impl.field())
        .map(value => zio.aws.lakeformation.model.FieldNameString.wrap(value))
    override val comparisonOperator
        : Option[zio.aws.lakeformation.model.ComparisonOperator] = scala
      .Option(impl.comparisonOperator())
      .map(value => zio.aws.lakeformation.model.ComparisonOperator.wrap(value))
    override val stringValueList: Option[List[StringValue]] = scala
      .Option(impl.stringValueList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.primitives.StringValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.FilterCondition
  ): zio.aws.lakeformation.model.FilterCondition.ReadOnly = new Wrapper(impl)
}
