package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{
  NameString,
  NullableBoolean,
  CatalogIdString
}
import scala.jdk.CollectionConverters._
final case class DataLakeSettings(
    dataLakeAdmins: Option[
      Iterable[zio.aws.lakeformation.model.DataLakePrincipal]
    ] = None,
    createDatabaseDefaultPermissions: Option[
      Iterable[zio.aws.lakeformation.model.PrincipalPermissions]
    ] = None,
    createTableDefaultPermissions: Option[
      Iterable[zio.aws.lakeformation.model.PrincipalPermissions]
    ] = None,
    trustedResourceOwners: Option[Iterable[CatalogIdString]] = None,
    allowExternalDataFiltering: Option[NullableBoolean] = None,
    externalDataFilteringAllowList: Option[
      Iterable[zio.aws.lakeformation.model.DataLakePrincipal]
    ] = None,
    authorizedSessionTagValueList: Option[Iterable[NameString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DataLakeSettings = {
    import DataLakeSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DataLakeSettings
      .builder()
      .optionallyWith(
        dataLakeAdmins.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataLakeAdmins)
      .optionallyWith(
        createDatabaseDefaultPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createDatabaseDefaultPermissions)
      .optionallyWith(
        createTableDefaultPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createTableDefaultPermissions)
      .optionallyWith(
        trustedResourceOwners.map(value =>
          value.map { item =>
            CatalogIdString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trustedResourceOwners)
      .optionallyWith(
        allowExternalDataFiltering.map(value => value: java.lang.Boolean)
      )(_.allowExternalDataFiltering)
      .optionallyWith(
        externalDataFilteringAllowList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.externalDataFilteringAllowList)
      .optionallyWith(
        authorizedSessionTagValueList.map(value =>
          value.map { item =>
            NameString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.authorizedSessionTagValueList)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DataLakeSettings.ReadOnly =
    zio.aws.lakeformation.model.DataLakeSettings.wrap(buildAwsValue())
}
object DataLakeSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DataLakeSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DataLakeSettings =
      zio.aws.lakeformation.model.DataLakeSettings(
        dataLakeAdmins.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createDatabaseDefaultPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createTableDefaultPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        trustedResourceOwners.map(value => value),
        allowExternalDataFiltering.map(value => value),
        externalDataFilteringAllowList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        authorizedSessionTagValueList.map(value => value)
      )
    def dataLakeAdmins
        : Option[List[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]]
    def createDatabaseDefaultPermissions: Option[
      List[zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly]
    ]
    def createTableDefaultPermissions: Option[
      List[zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly]
    ]
    def trustedResourceOwners: Option[List[CatalogIdString]]
    def allowExternalDataFiltering: Option[NullableBoolean]
    def externalDataFilteringAllowList
        : Option[List[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]]
    def authorizedSessionTagValueList: Option[List[NameString]]
    def getDataLakeAdmins: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField("dataLakeAdmins", dataLakeAdmins)
    def getCreateDatabaseDefaultPermissions: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "createDatabaseDefaultPermissions",
      createDatabaseDefaultPermissions
    )
    def getCreateTableDefaultPermissions: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "createTableDefaultPermissions",
      createTableDefaultPermissions
    )
    def getTrustedResourceOwners: ZIO[Any, AwsError, List[CatalogIdString]] =
      AwsError.unwrapOptionField("trustedResourceOwners", trustedResourceOwners)
    def getAllowExternalDataFiltering: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "allowExternalDataFiltering",
        allowExternalDataFiltering
      )
    def getExternalDataFilteringAllowList: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "externalDataFilteringAllowList",
      externalDataFilteringAllowList
    )
    def getAuthorizedSessionTagValueList: ZIO[Any, AwsError, List[NameString]] =
      AwsError.unwrapOptionField(
        "authorizedSessionTagValueList",
        authorizedSessionTagValueList
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DataLakeSettings
  ) extends zio.aws.lakeformation.model.DataLakeSettings.ReadOnly {
    override val dataLakeAdmins
        : Option[List[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]] =
      scala
        .Option(impl.dataLakeAdmins())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.DataLakePrincipal.wrap(item)
          }.toList
        )
    override val createDatabaseDefaultPermissions: Option[
      List[zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly]
    ] = scala
      .Option(impl.createDatabaseDefaultPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.PrincipalPermissions.wrap(item)
        }.toList
      )
    override val createTableDefaultPermissions: Option[
      List[zio.aws.lakeformation.model.PrincipalPermissions.ReadOnly]
    ] = scala
      .Option(impl.createTableDefaultPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.PrincipalPermissions.wrap(item)
        }.toList
      )
    override val trustedResourceOwners: Option[List[CatalogIdString]] = scala
      .Option(impl.trustedResourceOwners())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.primitives.CatalogIdString(item)
        }.toList
      )
    override val allowExternalDataFiltering: Option[NullableBoolean] = scala
      .Option(impl.allowExternalDataFiltering())
      .map(value => value: NullableBoolean)
    override val externalDataFilteringAllowList
        : Option[List[zio.aws.lakeformation.model.DataLakePrincipal.ReadOnly]] =
      scala
        .Option(impl.externalDataFilteringAllowList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lakeformation.model.DataLakePrincipal.wrap(item)
          }.toList
        )
    override val authorizedSessionTagValueList: Option[List[NameString]] = scala
      .Option(impl.authorizedSessionTagValueList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.primitives.NameString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DataLakeSettings
  ): zio.aws.lakeformation.model.DataLakeSettings.ReadOnly = new Wrapper(impl)
}
