package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.{ETagString, URI}
import scala.jdk.CollectionConverters._
final case class VirtualObject(uri: URI, eTag: Option[ETagString] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.VirtualObject = {
    import VirtualObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.VirtualObject
      .builder()
      .uri(URI.unwrap(uri): java.lang.String)
      .optionallyWith(
        eTag.map(value => ETagString.unwrap(value): java.lang.String)
      )(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.VirtualObject.ReadOnly =
    zio.aws.lakeformation.model.VirtualObject.wrap(buildAwsValue())
}
object VirtualObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.VirtualObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.VirtualObject =
      zio.aws.lakeformation.model.VirtualObject(uri, eTag.map(value => value))
    def uri: URI
    def eTag: Option[ETagString]
    def getUri: ZIO[Any, Nothing, URI] = ZIO.succeed(uri)
    def getETag: ZIO[Any, AwsError, ETagString] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.VirtualObject
  ) extends zio.aws.lakeformation.model.VirtualObject.ReadOnly {
    override val uri: URI =
      zio.aws.lakeformation.model.primitives.URI(impl.uri())
    override val eTag: Option[ETagString] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.lakeformation.model.primitives.ETagString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.VirtualObject
  ): zio.aws.lakeformation.model.VirtualObject.ReadOnly = new Wrapper(impl)
}
