package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.TransactionIdString
import scala.jdk.CollectionConverters._
final case class StartTransactionResponse(
    transactionId: Option[TransactionIdString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse = {
    import StartTransactionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse
      .builder()
      .optionallyWith(
        transactionId.map(value =>
          TransactionIdString.unwrap(value): java.lang.String
        )
      )(_.transactionId)
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.StartTransactionResponse.ReadOnly =
    zio.aws.lakeformation.model.StartTransactionResponse.wrap(buildAwsValue())
}
object StartTransactionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.StartTransactionResponse =
      zio.aws.lakeformation.model
        .StartTransactionResponse(transactionId.map(value => value))
    def transactionId: Option[TransactionIdString]
    def getTransactionId: ZIO[Any, AwsError, TransactionIdString] =
      AwsError.unwrapOptionField("transactionId", transactionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse
  ) extends zio.aws.lakeformation.model.StartTransactionResponse.ReadOnly {
    override val transactionId: Option[TransactionIdString] = scala
      .Option(impl.transactionId())
      .map(value =>
        zio.aws.lakeformation.model.primitives.TransactionIdString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse
  ): zio.aws.lakeformation.model.StartTransactionResponse.ReadOnly =
    new Wrapper(impl)
}
