package zio.aws.lakeformation.model
import scala.jdk.CollectionConverters._
sealed trait PermissionType {
  def unwrap: software.amazon.awssdk.services.lakeformation.model.PermissionType
}
object PermissionType {
  def wrap(
      value: software.amazon.awssdk.services.lakeformation.model.PermissionType
  ): zio.aws.lakeformation.model.PermissionType = value match {
    case software.amazon.awssdk.services.lakeformation.model.PermissionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lakeformation.model.PermissionType.COLUMN_PERMISSION =>
      val r = COLUMN_PERMISSION
      r
    case software.amazon.awssdk.services.lakeformation.model.PermissionType.CELL_FILTER_PERMISSION =>
      val r = CELL_FILTER_PERMISSION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lakeformation.model.PermissionType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.PermissionType =
      software.amazon.awssdk.services.lakeformation.model.PermissionType.UNKNOWN_TO_SDK_VERSION
  }
  case object COLUMN_PERMISSION
      extends zio.aws.lakeformation.model.PermissionType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.PermissionType =
      software.amazon.awssdk.services.lakeformation.model.PermissionType.COLUMN_PERMISSION
  }
  case object CELL_FILTER_PERMISSION
      extends zio.aws.lakeformation.model.PermissionType {
    override def unwrap
        : software.amazon.awssdk.services.lakeformation.model.PermissionType =
      software.amazon.awssdk.services.lakeformation.model.PermissionType.CELL_FILTER_PERMISSION
  }
}
