package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListPermissionsResponse(
    principalResourcePermissions: Option[
      Iterable[zio.aws.lakeformation.model.PrincipalResourcePermissions]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse = {
    import ListPermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse
      .builder()
      .optionallyWith(
        principalResourcePermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.principalResourcePermissions)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ListPermissionsResponse.ReadOnly =
    zio.aws.lakeformation.model.ListPermissionsResponse.wrap(buildAwsValue())
}
object ListPermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ListPermissionsResponse =
      zio.aws.lakeformation.model.ListPermissionsResponse(
        principalResourcePermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def principalResourcePermissions: Option[
      List[zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getPrincipalResourcePermissions: ZIO[Any, AwsError, List[
      zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "principalResourcePermissions",
      principalResourcePermissions
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse
  ) extends zio.aws.lakeformation.model.ListPermissionsResponse.ReadOnly {
    override val principalResourcePermissions: Option[
      List[zio.aws.lakeformation.model.PrincipalResourcePermissions.ReadOnly]
    ] = scala
      .Option(impl.principalResourcePermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.PrincipalResourcePermissions.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lakeformation.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse
  ): zio.aws.lakeformation.model.ListPermissionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
