package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.{
  SyntheticGetWorkUnitResultsRequestWorkUnitTokenString,
  GetWorkUnitResultsRequestWorkUnitIdLong,
  GetWorkUnitResultsRequestQueryIdString
}
import scala.jdk.CollectionConverters._
final case class GetWorkUnitResultsRequest(
    queryId: GetWorkUnitResultsRequestQueryIdString,
    workUnitId: GetWorkUnitResultsRequestWorkUnitIdLong,
    workUnitToken: SyntheticGetWorkUnitResultsRequestWorkUnitTokenString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest = {
    import GetWorkUnitResultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest
      .builder()
      .queryId(
        GetWorkUnitResultsRequestQueryIdString.unwrap(queryId): java.lang.String
      )
      .workUnitId(
        GetWorkUnitResultsRequestWorkUnitIdLong.unwrap(
          workUnitId
        ): java.lang.Long
      )
      .workUnitToken(
        SyntheticGetWorkUnitResultsRequestWorkUnitTokenString.unwrap(
          workUnitToken
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lakeformation.model.GetWorkUnitResultsRequest.ReadOnly =
    zio.aws.lakeformation.model.GetWorkUnitResultsRequest.wrap(buildAwsValue())
}
object GetWorkUnitResultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.GetWorkUnitResultsRequest =
      zio.aws.lakeformation.model
        .GetWorkUnitResultsRequest(queryId, workUnitId, workUnitToken)
    def queryId: GetWorkUnitResultsRequestQueryIdString
    def workUnitId: GetWorkUnitResultsRequestWorkUnitIdLong
    def workUnitToken: SyntheticGetWorkUnitResultsRequestWorkUnitTokenString
    def getQueryId: ZIO[Any, Nothing, GetWorkUnitResultsRequestQueryIdString] =
      ZIO.succeed(queryId)
    def getWorkUnitId
        : ZIO[Any, Nothing, GetWorkUnitResultsRequestWorkUnitIdLong] =
      ZIO.succeed(workUnitId)
    def getWorkUnitToken: ZIO[
      Any,
      Nothing,
      SyntheticGetWorkUnitResultsRequestWorkUnitTokenString
    ] = ZIO.succeed(workUnitToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest
  ) extends zio.aws.lakeformation.model.GetWorkUnitResultsRequest.ReadOnly {
    override val queryId: GetWorkUnitResultsRequestQueryIdString =
      zio.aws.lakeformation.model.primitives
        .GetWorkUnitResultsRequestQueryIdString(impl.queryId())
    override val workUnitId: GetWorkUnitResultsRequestWorkUnitIdLong =
      zio.aws.lakeformation.model.primitives
        .GetWorkUnitResultsRequestWorkUnitIdLong(impl.workUnitId())
    override val workUnitToken
        : SyntheticGetWorkUnitResultsRequestWorkUnitTokenString =
      zio.aws.lakeformation.model.primitives
        .SyntheticGetWorkUnitResultsRequestWorkUnitTokenString(
          impl.workUnitToken()
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest
  ): zio.aws.lakeformation.model.GetWorkUnitResultsRequest.ReadOnly =
    new Wrapper(impl)
}
