package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lakeformation.model.primitives.ResourceArnString
import scala.jdk.CollectionConverters._
final case class DescribeResourceRequest(resourceArn: ResourceArnString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest = {
    import DescribeResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.DescribeResourceRequest.ReadOnly =
    zio.aws.lakeformation.model.DescribeResourceRequest.wrap(buildAwsValue())
}
object DescribeResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.DescribeResourceRequest =
      zio.aws.lakeformation.model.DescribeResourceRequest(resourceArn)
    def resourceArn: ResourceArnString
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest
  ) extends zio.aws.lakeformation.model.DescribeResourceRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.lakeformation.model.primitives
        .ResourceArnString(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest
  ): zio.aws.lakeformation.model.DescribeResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
