package zio.aws.lakeformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lakeformation.model.primitives.NameString
import scala.jdk.CollectionConverters._
final case class ColumnWildcard(
    excludedColumnNames: Option[Iterable[NameString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lakeformation.model.ColumnWildcard = {
    import ColumnWildcard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lakeformation.model.ColumnWildcard
      .builder()
      .optionallyWith(
        excludedColumnNames.map(value =>
          value.map { item =>
            NameString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedColumnNames)
      .build()
  }
  def asReadOnly: zio.aws.lakeformation.model.ColumnWildcard.ReadOnly =
    zio.aws.lakeformation.model.ColumnWildcard.wrap(buildAwsValue())
}
object ColumnWildcard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lakeformation.model.ColumnWildcard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lakeformation.model.ColumnWildcard =
      zio.aws.lakeformation.model
        .ColumnWildcard(excludedColumnNames.map(value => value))
    def excludedColumnNames: Option[List[NameString]]
    def getExcludedColumnNames: ZIO[Any, AwsError, List[NameString]] =
      AwsError.unwrapOptionField("excludedColumnNames", excludedColumnNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lakeformation.model.ColumnWildcard
  ) extends zio.aws.lakeformation.model.ColumnWildcard.ReadOnly {
    override val excludedColumnNames: Option[List[NameString]] = scala
      .Option(impl.excludedColumnNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lakeformation.model.primitives.NameString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lakeformation.model.ColumnWildcard
  ): zio.aws.lakeformation.model.ColumnWildcard.ReadOnly = new Wrapper(impl)
}
